/*
 * Decompiled with CFR 0.152.
 */
package phat.server.commands.tests;

import com.jme3.app.SimpleApplication;
import com.jme3.app.state.AppState;
import com.jme3.app.state.AppStateManager;
import com.jme3.bullet.BulletAppState;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import java.util.logging.Logger;
import phat.app.PHATApplication;
import phat.app.PHATInitAppListener;
import phat.commands.PHATCommand;
import phat.devices.DevicesAppState;
import phat.devices.commands.CreateSmartphoneCommand;
import phat.devices.commands.PHATDeviceCommand;
import phat.devices.commands.SetDeviceOnFurnitureCommand;
import phat.environment.SpatialEnvironmentAPI;
import phat.structures.houses.HouseFactory;
import phat.structures.houses.TestHouse;
import phat.structures.houses.commands.CreateHouseCommand;
import phat.world.WorldAppState;

public class CreateSmartphoneTest
implements PHATInitAppListener {
    private static final Logger logger = Logger.getLogger(TestHouse.class.getName());
    DevicesAppState devicesAppState;
    SpatialEnvironmentAPI seAPI;

    public static void main(String[] args) {
        CreateSmartphoneTest test = new CreateSmartphoneTest();
        PHATApplication phat = new PHATApplication((PHATInitAppListener)test);
        phat.setDisplayFps(true);
        phat.setDisplayStatView(false);
        phat.start();
    }

    public void init(SimpleApplication app) {
        AppStateManager stateManager = app.getStateManager();
        app.getFlyByCamera().setMoveSpeed(10.0f);
        app.getCamera().setLocation(new Vector3f(4.497525f, 6.3693237f, 4.173162f));
        app.getCamera().setRotation(new Quaternion(0.5199084f, 0.42191547f, -0.32954147f, 0.6656463f));
        BulletAppState bulletAppState = new BulletAppState();
        stateManager.attach((AppState)bulletAppState);
        this.seAPI = SpatialEnvironmentAPI.createSpatialEnvironmentAPI((SimpleApplication)app);
        this.seAPI.getWorldAppState().setCalendar(2013, 1, 1, 12, 0, 0);
        this.seAPI.getWorldAppState().setLandType(WorldAppState.LandType.Basic);
        this.seAPI.getHouseAppState().runCommand((PHATCommand)new CreateHouseCommand("House1", HouseFactory.HouseType.House3room2bath));
        this.devicesAppState = new DevicesAppState();
        stateManager.attach((AppState)this.devicesAppState);
        this.devicesAppState.runCommand((PHATDeviceCommand)new CreateSmartphoneCommand("Smartphone1"));
        this.devicesAppState.runCommand((PHATDeviceCommand)new SetDeviceOnFurnitureCommand("Smartphone1", "House1", "Table1"));
    }
}

