/*
 * Decompiled with CFR 0.152.
 */
package phat.server.commands;

import com.jme3.app.Application;
import com.jme3.material.Material;
import com.jme3.scene.Geometry;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.control.Control;
import java.util.List;
import java.util.logging.Level;
import phat.commands.PHATCommand;
import phat.commands.PHATCommandListener;
import phat.devices.DevicesAppState;
import phat.devices.controls.ScreenAVDControl;
import phat.devices.smartphone.SmartPhoneFactory;
import phat.mobile.adm.AndroidVirtualDevice;
import phat.server.ServerAppState;
import phat.server.commands.PHATServerCommand;
import phat.util.SpatialUtils;

public class DisplayAVDScreenCommand
extends PHATServerCommand {
    private String smartphoneId;
    private String avdId;
    private float frecuency = 1.0f;
    private boolean on = true;

    public DisplayAVDScreenCommand(String smartphoneId, String avdId) {
        this(smartphoneId, avdId, null);
    }

    public DisplayAVDScreenCommand(String smartphoneId, String avdId, boolean on) {
        this(smartphoneId, avdId, on, null);
    }

    public DisplayAVDScreenCommand(String smartphoneId, String avdId, PHATCommandListener listener) {
        this(smartphoneId, avdId, true, null);
    }

    public DisplayAVDScreenCommand(String smartphoneId, String avdId, boolean on, PHATCommandListener listener) {
        super(listener);
        this.smartphoneId = smartphoneId;
        this.avdId = avdId;
        this.on = on;
        logger.log(Level.INFO, "New Command: {0}", new Object[]{this});
    }

    public void runCommand(Application app) {
        DevicesAppState devicesAppState = (DevicesAppState)app.getStateManager().getState(DevicesAppState.class);
        ServerAppState serverAppState = (ServerAppState)app.getStateManager().getState(ServerAppState.class);
        Node device = devicesAppState.getDevice(this.smartphoneId);
        AndroidVirtualDevice avd = serverAppState.getAVD(this.smartphoneId);
        if (device != null && avd != null) {
            List screens = SpatialUtils.getSpatialsByRole((Spatial)device, (String)"Screen");
            System.out.println("#Screen = " + screens.size());
            if (screens.size() > 0) {
                Spatial screen = (Spatial)screens.get(0);
                ScreenAVDControl c = (ScreenAVDControl)screen.getControl(ScreenAVDControl.class);
                if (this.on && c == null) {
                    screen.setMaterial(new Material(SmartPhoneFactory.assetManager, "Common/MatDefs/Misc/Unshaded.j3md"));
                    c = new ScreenAVDControl((Geometry)screen, avd);
                    screen.addControl((Control)c);
                    c.setFrecuency(this.frecuency);
                } else if (!this.on && c != null) {
                    screen.removeControl((Control)c);
                }
                this.setState(PHATCommand.State.Success);
                return;
            }
        }
        this.setState(PHATCommand.State.Fail);
    }

    public void interruptCommand(Application app) {
        this.setState(PHATCommand.State.Interrupted);
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "(" + this.smartphoneId + ", " + this.avdId + ", " + this.on + ")";
    }

    public float getFrecuency() {
        return this.frecuency;
    }

    public void setFrecuency(float frecuency) {
        this.frecuency = frecuency;
    }
}

