/*
 * Decompiled with CFR 0.152.
 */
package phat.server.actuators;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.util.logging.Level;
import java.util.logging.Logger;
import phat.devices.actuators.VibratorActuator;
import phat.server.TCPSensorServer;
import phat.server.microphone.TCPAudioMicroServer;
import sim.android.hardware.service.vibrator.SimVibrateAction;
import sim.android.hardware.service.vibrator.SimVibrateCancelAction;
import sim.android.hardware.service.vibrator.SimVibratePatternAction;

public class UDPVibratorServer
implements TCPSensorServer {
    protected DatagramSocket serverSocket;
    private Thread serverThread;
    private boolean endServer = false;
    VibratorActuator vibrator;
    byte[] buffer = new byte[200];

    public UDPVibratorServer(InetAddress ip, int port, VibratorActuator vibrator) throws IOException {
        this.vibrator = vibrator;
        this.serverSocket = new DatagramSocket(port, ip);
    }

    @Override
    public String getIp() {
        System.out.println("ServerSocket.getIp() = " + this.serverSocket.getLocalAddress());
        return this.serverSocket.getLocalAddress().getHostAddress();
    }

    @Override
    public int getPort() {
        return this.serverSocket.getLocalPort();
    }

    @Override
    public synchronized void start() {
        this.serverThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    while (!UDPVibratorServer.this.endServer) {
                        try {
                            DatagramPacket request = new DatagramPacket(UDPVibratorServer.this.buffer, UDPVibratorServer.this.buffer.length);
                            UDPVibratorServer.this.serverSocket.receive(request);
                            UDPVibratorServer.this.proccessRequest(request);
                        }
                        catch (SocketException ex) {
                            if (UDPVibratorServer.this.endServer) continue;
                            Logger.getLogger(TCPAudioMicroServer.class.getName()).log(Level.SEVERE, null, ex);
                        }
                    }
                    UDPVibratorServer.this.serverSocket.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(TCPAudioMicroServer.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        });
        this.serverThread.start();
    }

    private synchronized void proccessRequest(DatagramPacket request) {
        String action = new String(request.getData());
        action = action.trim();
        System.out.println("\n\nNew Request: [" + action + "]");
        System.out.println("dataLenght = " + action.length());
        System.out.println("\n\n");
        if (SimVibrateAction.isAnSpec((String)action)) {
            SimVibrateAction sva = SimVibrateAction.fromString((String)action);
            this.vibrator.vibrate(sva.getMilliseconds());
        } else if (SimVibratePatternAction.isAnSpec((String)action)) {
            SimVibratePatternAction sva = SimVibratePatternAction.fromString((String)action);
            this.vibrator.vibrate(sva.getPattern(), sva.getRepeat());
        } else if (SimVibrateCancelAction.isAnSpec((String)action)) {
            SimVibrateCancelAction sva = SimVibrateCancelAction.fromString((String)action);
            this.vibrator.cancel();
        }
    }

    @Override
    public synchronized void stop() {
        this.endServer = true;
    }
}

