/*
 * Decompiled with CFR 0.152.
 */
package phat.server;

import com.jme3.scene.Node;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import phat.devices.actuators.VibratorActuator;
import phat.mobile.servicemanager.server.ServiceManagerServer;
import phat.mobile.servicemanager.services.Service;
import phat.mobile.servicemanager.services.ServiceImpl;
import phat.sensors.accelerometer.AccelerometerControl;
import phat.sensors.camera.CameraSensor;
import phat.sensors.door.PHATDoorSensor;
import phat.sensors.microphone.MicrophoneControl;
import phat.sensors.presence.PHATPresenceSensor;
import phat.server.ServerAppState;
import phat.server.TCPSensorServer;
import phat.server.accelerometer.TCPAccelerometerServer;
import phat.server.actuators.UDPVibratorServer;
import phat.server.camera.TCPCameraSensorServer;
import phat.server.doorSensor.TCPDoorSensorServer;
import phat.server.microphone.TCPAudioMicroServer;
import phat.server.presence.TCPPresenceServer;
import phat.server.speaker.TCPAudioSpeakerServer;

public class PHATServerManager {
    InetAddress inetAddress = PHATServerManager.getAddress();
    Map<String, List<TCPSensorServer>> tcpSensorServers = new HashMap<String, List<TCPSensorServer>>();

    public TCPAudioMicroServer createAndStartAudioMicroServer(String servicesetid, String serviceid, MicrophoneControl mc) {
        TCPAudioMicroServer ams = null;
        int port = ServiceManagerServer.getInstance().getNextPort();
        try {
            System.out.println("IP:PORT -> " + this.inetAddress + ":" + port);
            ams = new TCPAudioMicroServer(this.inetAddress, port, mc);
        }
        catch (IOException ex) {
            Logger.getLogger(PHATServerManager.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
        this.registerService(serviceid, serviceid, ams, "microphone");
        ams.start();
        this.add(servicesetid, ams);
        return ams;
    }

    public TCPCameraSensorServer createAndStartCameraServer(String servicesetid, String serviceid, CameraSensor cameraSensor) {
        TCPCameraSensorServer ams = null;
        int port = ServiceManagerServer.getInstance().getNextPort();
        try {
            System.out.println("IP:PORT -> " + this.inetAddress + ":" + port);
            ams = new TCPCameraSensorServer(this.inetAddress, port, cameraSensor);
        }
        catch (IOException ex) {
            Logger.getLogger(PHATServerManager.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
        this.registerService(servicesetid, serviceid, ams, "camera");
        ams.start();
        this.add(servicesetid, ams);
        return ams;
    }

    public TCPAccelerometerServer createAndStartAccelerometerServer(String servicesetid, String serviceid, AccelerometerControl accSensor) {
        TCPAccelerometerServer ams = null;
        int port = ServiceManagerServer.getInstance().getNextPort();
        try {
            System.out.println("IP:PORT -> " + this.inetAddress + ":" + port);
            ams = new TCPAccelerometerServer(this.inetAddress, port, accSensor);
        }
        catch (IOException ex) {
            Logger.getLogger(PHATServerManager.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
        this.registerService(servicesetid, serviceid, ams, "accelerometer");
        ams.start();
        this.add(servicesetid, ams);
        return ams;
    }

    public TCPPresenceServer createAndStartPresenceServer(String servicesetid, String serviceid, PHATPresenceSensor accSensor) {
        TCPPresenceServer ams = null;
        int port = ServiceManagerServer.getInstance().getNextPort();
        try {
            System.out.println("IP:PORT -> " + this.inetAddress + ":" + port);
            ams = new TCPPresenceServer(this.inetAddress, port, accSensor);
        }
        catch (IOException ex) {
            Logger.getLogger(PHATServerManager.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
        this.registerService(servicesetid, serviceid, ams, "presence");
        ams.start();
        this.add(servicesetid, ams);
        return ams;
    }

    public TCPDoorSensorServer createAndStartDoorSensorServer(String servicesetid, String serviceid, PHATDoorSensor doorSensor) {
        TCPDoorSensorServer ams = null;
        int port = ServiceManagerServer.getInstance().getNextPort();
        try {
            System.out.println("IP:PORT -> " + this.inetAddress + ":" + port);
            ams = new TCPDoorSensorServer(this.inetAddress, port, doorSensor);
        }
        catch (IOException ex) {
            Logger.getLogger(PHATServerManager.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
        this.registerService(servicesetid, serviceid, ams, "door");
        ams.start();
        this.add(servicesetid, ams);
        return ams;
    }

    public UDPVibratorServer createAndStartVibratorServer(String servicesetid, String serviceid, VibratorActuator vibratorActuator) {
        UDPVibratorServer vs = null;
        int port = ServiceManagerServer.getInstance().getNextPort();
        try {
            System.out.println("IP:PORT -> " + this.inetAddress + ":" + port);
            vs = new UDPVibratorServer(this.inetAddress, port, vibratorActuator);
        }
        catch (IOException ex) {
            Logger.getLogger(PHATServerManager.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
        this.registerService(servicesetid, serviceid, vs, "vibrator");
        vs.start();
        this.add(servicesetid, vs);
        return vs;
    }

    public TCPAudioSpeakerServer createAndStartAudioSpeakerServer(ServerAppState serverAppState, String servicesetid, String serviceid, Node device) {
        TCPAudioSpeakerServer ams = null;
        int port = ServiceManagerServer.getInstance().getNextPort();
        try {
            System.out.println("IP:PORT -> " + this.inetAddress + ":" + port);
            ams = new TCPAudioSpeakerServer(serverAppState, this.inetAddress, port, device);
        }
        catch (IOException ex) {
            Logger.getLogger(PHATServerManager.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
        this.registerService(serviceid, serviceid, ams, "speaker");
        ams.start();
        this.add(servicesetid, ams);
        return ams;
    }

    public void stop() {
        for (List<TCPSensorServer> list : this.tcpSensorServers.values()) {
            for (TCPSensorServer server : list) {
                server.stop();
            }
        }
        ServiceManagerServer.getInstance().stop();
    }

    private void add(String id, TCPSensorServer server) {
        List<TCPSensorServer> list = this.tcpSensorServers.get(id);
        if (list == null) {
            list = new ArrayList<TCPSensorServer>();
            this.tcpSensorServers.put(id, list);
        }
        list.add(server);
    }

    private void registerService(String serviceSetId, String serviceid, TCPSensorServer server, String type) {
        ServiceImpl service = new ServiceImpl(serviceid, type, server.getIp(), server.getPort());
        System.out.println("New Service: " + service);
        ServiceManagerServer sms = ServiceManagerServer.getInstance();
        sms.getServiceManager().registerService(serviceSetId, (Service)service);
    }

    public String getIP() {
        return this.inetAddress.getHostAddress();
    }

    public static int getPort() {
        return 65056;
    }

    public static InetAddress getAddress() {
        try {
            Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
            while (e.hasMoreElements()) {
                NetworkInterface ni = e.nextElement();
                System.out.println("NetworkInterface = " + ni.getName());
                if (!ni.getName().contains("eth") && !ni.getName().contains("wlan")) continue;
                Enumeration<InetAddress> ee = ni.getInetAddresses();
                while (ee.hasMoreElements()) {
                    InetAddress ip = ee.nextElement();
                    if (!(ip instanceof Inet4Address) || ip.getAddress() == null) continue;
                    return ip;
                }
            }
            NetworkInterface lo = NetworkInterface.getByName("lo");
            if (lo != null) {
                Enumeration<InetAddress> ee = lo.getInetAddresses();
                while (ee.hasMoreElements()) {
                    InetAddress ip = ee.nextElement();
                    if (!(ip instanceof Inet4Address) || ip.getAddress() == null) continue;
                    return ip;
                }
            }
        }
        catch (Exception e) {
            System.err.println("Error");
        }
        return null;
    }
}

