/*
 * Copyright (C) 2014 Pablo Campillo-Sanchez <pabcampi@ucm.es>
 *
 * This software has been developed as part of the 
 * SociAAL project directed by Jorge J. Gomez Sanz
 * (http://grasia.fdi.ucm.es/sociaal)
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package phat.server;

import com.jme3.scene.Node;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import phat.devices.actuators.VibratorActuator;
import phat.mobile.servicemanager.CommonVars;
import phat.mobile.servicemanager.server.ServiceManagerServer;
import phat.mobile.servicemanager.services.Service;
import phat.mobile.servicemanager.services.ServiceImpl;
import phat.sensors.accelerometer.AccelerometerControl;
import phat.sensors.camera.CameraSensor;
import phat.sensors.door.PHATDoorSensor;
import phat.server.microphone.TCPAudioMicroServer;
import phat.sensors.microphone.MicrophoneControl;
import phat.sensors.presence.PHATPresenceSensor;
import phat.server.accelerometer.TCPAccelerometerServer;
import phat.server.actuators.UDPVibratorServer;
import phat.server.camera.TCPCameraSensorServer;
import phat.server.doorSensor.TCPDoorSensorServer;
import phat.server.presence.TCPPresenceServer;
import phat.server.speaker.TCPAudioSpeakerServer;

/**
 *
 * @author Pablo
 */
public class PHATServerManager {

    InetAddress inetAddress = getAddress();
    Map<String, List<TCPSensorServer>> tcpSensorServers = new HashMap<String, List<TCPSensorServer>>();

    public TCPAudioMicroServer createAndStartAudioMicroServer(String servicesetid,String serviceid, MicrophoneControl mc) {
        TCPAudioMicroServer ams = null;
        int port = ServiceManagerServer.getInstance().getNextPort();
        try {
            System.out.println("IP:PORT -> " + inetAddress + ":" + port);
            ams = new TCPAudioMicroServer(inetAddress, port, mc);
        } catch (IOException ex) {
            Logger.getLogger(PHATServerManager.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }

        registerService(serviceid,serviceid, ams, Service.MICROPHONE);

        ams.start();

        add(servicesetid, ams);

        return ams;
    }

    public TCPCameraSensorServer createAndStartCameraServer(String servicesetid,String serviceid, CameraSensor cameraSensor) {
        TCPCameraSensorServer ams = null;
        int port = ServiceManagerServer.getInstance().getNextPort();
        try {
            System.out.println("IP:PORT -> " + inetAddress + ":" + port);
            ams = new TCPCameraSensorServer(inetAddress, port, cameraSensor);
        } catch (IOException ex) {
            Logger.getLogger(PHATServerManager.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }

        registerService(servicesetid,serviceid, ams, Service.CAMERA);

        ams.start();

        add(servicesetid, ams);

        return ams;
    }

    public TCPAccelerometerServer createAndStartAccelerometerServer(String servicesetid,String serviceid, AccelerometerControl accSensor) {
        TCPAccelerometerServer ams = null;
        int port = ServiceManagerServer.getInstance().getNextPort();
        try {
            System.out.println("IP:PORT -> " + inetAddress + ":" + port);
            ams = new TCPAccelerometerServer(inetAddress, port, accSensor);
        } catch (IOException ex) {
            Logger.getLogger(PHATServerManager.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }

        registerService(servicesetid,serviceid, ams, Service.ACCELEROMETER);

        ams.start();

        add(servicesetid, ams);

        return ams;
    }

    public TCPPresenceServer createAndStartPresenceServer(String servicesetid,String serviceid, PHATPresenceSensor accSensor) {
        TCPPresenceServer ams = null;
        int port = ServiceManagerServer.getInstance().getNextPort();
        try {
            System.out.println("IP:PORT -> " + inetAddress + ":" + port);
            ams = new TCPPresenceServer(inetAddress, port, accSensor);
        } catch (IOException ex) {
            Logger.getLogger(PHATServerManager.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }

        registerService(servicesetid,serviceid, ams, Service.PRESENCE);

        ams.start();

        add(servicesetid, ams);

        return ams;
    }
    
    public TCPDoorSensorServer createAndStartDoorSensorServer(String servicesetid,String serviceid,  PHATDoorSensor doorSensor) {
        TCPDoorSensorServer ams = null;
        int port = ServiceManagerServer.getInstance().getNextPort();
        try {
            System.out.println("IP:PORT -> " + inetAddress + ":" + port);
            ams = new TCPDoorSensorServer(inetAddress, port, doorSensor);
        } catch (IOException ex) {
            Logger.getLogger(PHATServerManager.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }

        registerService(servicesetid, serviceid, ams, Service.DOOR);

        ams.start();

        add(servicesetid, ams);

        return ams;
    }
    
  public UDPVibratorServer createAndStartVibratorServer(String servicesetid, String serviceid, VibratorActuator vibratorActuator) {
        UDPVibratorServer vs = null;
        int port = ServiceManagerServer.getInstance().getNextPort();
        try {
            System.out.println("IP:PORT -> " + inetAddress + ":" + port);
            vs = new UDPVibratorServer(inetAddress, port, vibratorActuator);
        } catch (IOException ex) {
            Logger.getLogger(PHATServerManager.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }

        registerService(servicesetid, serviceid, vs, Service.VIBRATOR);

        vs.start();

        add(servicesetid, vs);

        return vs;
    }
  
  public TCPAudioSpeakerServer createAndStartAudioSpeakerServer(ServerAppState serverAppState, String servicesetid, String serviceid, Node device) {
        TCPAudioSpeakerServer ams = null;
        int port = ServiceManagerServer.getInstance().getNextPort();
        try {
            System.out.println("IP:PORT -> " + inetAddress + ":" + port);
            ams = new TCPAudioSpeakerServer(serverAppState, inetAddress, port, device);
        } catch (IOException ex) {
            Logger.getLogger(PHATServerManager.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }

        registerService(serviceid,serviceid, ams, Service.SPEAKER);

        ams.start();

        add(servicesetid, ams);

        return ams;
    }
    
    public void stop() {
        for (List<TCPSensorServer> list : tcpSensorServers.values()) {
            for (TCPSensorServer server : list) {
                server.stop();
            }
        }
        ServiceManagerServer.getInstance().stop();
    }

    private void add(String id, TCPSensorServer server) {
        List<TCPSensorServer> list = tcpSensorServers.get(id);
        if (list == null) {
            list = new ArrayList<TCPSensorServer>();
            tcpSensorServers.put(id, list);
        }
        list.add(server);
    }

    private void registerService(String serviceSetId, String serviceid, TCPSensorServer server, String type) {
        Service service = new ServiceImpl(serviceid,type, server.getIp(), server.getPort());
        System.out.println("New Service: " + service);
        ServiceManagerServer sms = ServiceManagerServer.getInstance();
        sms.getServiceManager().registerService(serviceSetId, service);
    }

    public String getIP() {
        return inetAddress.getHostAddress();
    }
    
    public static int getPort() {
        return CommonVars.SERVICE_MANAGER_SERVER_PORT;
    }

    public static InetAddress getAddress() {
        try {
            for (Enumeration e = NetworkInterface.getNetworkInterfaces();
                    e.hasMoreElements();) {

                NetworkInterface ni = (NetworkInterface) e.nextElement();
                System.out.println("NetworkInterface = " + ni.getName());
                if (ni.getName().contains("eth") || ni.getName().contains("wlan")) {
                    for (Enumeration ee = ni.getInetAddresses(); ee.hasMoreElements();) {
                        InetAddress ip = (InetAddress) ee.nextElement();
                        if (ip instanceof Inet4Address && ip.getAddress() != null) {
                            return ip;
                        }
                        //System.out.println("Ip's: " + ip.getHostAddress());
                    }
                }
            }
            NetworkInterface lo = NetworkInterface.getByName("lo");
            if (lo != null) {
                for (Enumeration ee = lo.getInetAddresses(); ee.hasMoreElements();) {
                    InetAddress ip = (InetAddress) ee.nextElement();
                    if (ip instanceof Inet4Address && ip.getAddress() != null) {
                        return ip;
                    }
                }
            }
        } catch (Exception e) {
            System.err.println("Error");
        }
        return null;
    }
}
