/*
 * Decompiled with CFR 0.152.
 */
package phat.server.microphone;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import phat.sensors.Sensor;
import phat.sensors.SensorData;
import phat.sensors.SensorListener;
import phat.sensors.microphone.MicrophoneControl;
import phat.sensors.microphone.MicrophoneData;
import phat.server.TCPSensorServer;
import sim.android.media.service.AudioStreamDataPacket;

public class TCPAudioMicroServer
implements SensorListener,
TCPSensorServer {
    protected ServerSocket serverSocket;
    protected ObjectOutputStream oos;
    private String ip;
    private int port;
    private Thread serverThread;
    private Socket socket;
    private boolean endServer = false;
    MicrophoneControl mc;
    Random random = new Random();
    byte[] newRated = new byte[532];

    public TCPAudioMicroServer(InetAddress ip, int port, MicrophoneControl mc) throws IOException {
        this.ip = ip.getHostAddress();
        this.port = port;
        this.mc = mc;
        this.serverSocket = new ServerSocket(port, 0, ip);
    }

    @Override
    public String getIp() {
        return this.ip;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public void start() {
        this.serverThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    while (!TCPAudioMicroServer.this.endServer) {
                        try {
                            Socket socket = TCPAudioMicroServer.this.serverSocket.accept();
                            System.out.println("Nuevo Cliente: " + socket);
                            TCPAudioMicroServer.this.upClient(socket);
                        }
                        catch (SocketException ex) {
                            if (TCPAudioMicroServer.this.endServer) continue;
                            Logger.getLogger(TCPAudioMicroServer.class.getName()).log(Level.SEVERE, null, ex);
                        }
                    }
                }
                catch (IOException ex) {
                    Logger.getLogger(TCPAudioMicroServer.class.getName()).log(Level.SEVERE, null, ex);
                    TCPAudioMicroServer.this.socket = null;
                    TCPAudioMicroServer.this.oos = null;
                }
            }
        });
        this.serverThread.start();
    }

    private synchronized void upClient(Socket socket) {
        this.socket = socket;
        this.mc.add((SensorListener)this);
        try {
            this.oos = new ObjectOutputStream(socket.getOutputStream());
        }
        catch (IOException ex) {
            Logger.getLogger(TCPAudioMicroServer.class.getName()).log(Level.SEVERE, null, ex);
            this.oos = null;
            this.socket = null;
        }
    }

    @Override
    public void stop() {
        this.mc.remove((SensorListener)this);
        try {
            this.endServer = true;
            this.serverSocket.close();
            if (this.oos != null) {
                this.oos.close();
                this.oos = null;
            }
            if (this.socket != null) {
                this.socket.close();
                this.socket = null;
            }
        }
        catch (IOException e1) {
            Logger.getLogger(this.getClass().getSimpleName()).log(Level.SEVERE, null, e1);
        }
    }

    public void update(Sensor source, SensorData sd) {
        if (this.socket == null || this.oos == null) {
            return;
        }
        if (sd instanceof MicrophoneData) {
            MicrophoneData microphoneData = (MicrophoneData)sd;
            if (this.socket != null && this.socket.isConnected() && this.oos != null) {
                try {
                    int totalSize = microphoneData.getData().length;
                    int frameSize = microphoneData.getAudioFormat().getFrameSize();
                    byte[] data = new byte[totalSize];
                    System.arraycopy(microphoneData.getData(), 0, data, 0, totalSize);
                    int i = 0;
                    int c = 0;
                    for (int j = 0; i < this.newRated.length - 1 && j < data.length - 1; i += 2, j += 6) {
                        this.newRated[i] = data[j];
                        this.newRated[i + 1] = data[j + 1];
                        if (c > 2) {
                            j -= 2;
                            c = 0;
                            continue;
                        }
                        ++c;
                    }
                    for (i = 1; i < this.newRated.length; i += 2) {
                        if (!this.random.nextBoolean()) continue;
                        int n = i;
                        this.newRated[n] = (byte)(this.newRated[n] + 1);
                    }
                    AudioStreamDataPacket asdp = new AudioStreamDataPacket(this.newRated, this.newRated.length / frameSize, frameSize);
                    this.oos.writeObject(asdp);
                    this.oos.flush();
                    this.oos.reset();
                }
                catch (IOException e1) {
                    Logger.getLogger(this.getClass().getSimpleName()).log(Level.SEVERE, null, e1);
                    this.socket = null;
                    this.oos = null;
                    return;
                }
            }
        }
    }

    public void cleanUp() {
        this.stop();
    }
}

