/*
 * Decompiled with CFR 0.152.
 */
package phat.server.commands;

import com.jme3.app.Application;
import com.jme3.scene.Node;
import java.util.logging.Level;
import phat.commands.PHATCommand;
import phat.commands.PHATCommandListener;
import phat.devices.DevicesAppState;
import phat.mobile.adm.AndroidVirtualDevice;
import phat.sensors.accelerometer.AccelerometerControl;
import phat.sensors.camera.CameraSensor;
import phat.sensors.microphone.MicrophoneControl;
import phat.server.PHATServerManager;
import phat.server.ServerAppState;
import phat.server.accelerometer.TCPAccelerometerServer;
import phat.server.camera.TCPCameraSensorServer;
import phat.server.commands.PHATServerCommand;
import phat.server.microphone.TCPAudioMicroServer;

public class SetAndroidEmulatorCommand
extends PHATServerCommand {
    private String smartphoneId;
    private String avdId;
    private String serialEmulator;
    private String emuOptions;

    public SetAndroidEmulatorCommand(String smartphoneId, String avdId, String serialEmulator) {
        this(smartphoneId, avdId, serialEmulator, null);
    }

    public SetAndroidEmulatorCommand(String smartphoneId, String avdId, String serialEmulator, PHATCommandListener listener) {
        super(listener);
        this.smartphoneId = smartphoneId;
        this.avdId = avdId;
        this.serialEmulator = serialEmulator;
        logger.log(Level.INFO, "New Command: {0}", new Object[]{this});
    }

    public void runCommand(Application app) {
        DevicesAppState devicesAppState = (DevicesAppState)app.getStateManager().getState(DevicesAppState.class);
        ServerAppState serverAppState = (ServerAppState)app.getStateManager().getState(ServerAppState.class);
        devicesAppState.registerAllAndroidDevicesInScenario();
        Node device = devicesAppState.getDevice(this.smartphoneId);
        if (device != null) {
            AccelerometerControl accSensor;
            MicrophoneControl micSensor;
            AndroidVirtualDevice avd = new AndroidVirtualDevice(this.avdId, this.serialEmulator, this.smartphoneId);
            if (this.emuOptions != null) {
                avd.setEmuOptions(this.emuOptions);
            }
            PHATServerManager serverManager = serverAppState.getServerManager();
            avd.sendConfigFileForService(serverManager.getIP(), serverManager.getPort());
            CameraSensor cameraSensor = (CameraSensor)device.getControl(CameraSensor.class);
            if (cameraSensor != null) {
                TCPCameraSensorServer cameraServer = serverAppState.getServerManager().createAndStartCameraServer(this.smartphoneId, "camback-" + this.smartphoneId, cameraSensor);
                cameraServer.setRate(1.0f);
            }
            if ((micSensor = (MicrophoneControl)device.getControl(MicrophoneControl.class)) != null) {
                TCPAudioMicroServer audioServer = serverManager.createAndStartAudioMicroServer(this.smartphoneId, "mic-" + this.smartphoneId, micSensor);
            }
            if ((accSensor = (AccelerometerControl)device.getControl(AccelerometerControl.class)) != null) {
                TCPAccelerometerServer accServer = serverManager.createAndStartAccelerometerServer(this.smartphoneId, "gsensor-" + this.smartphoneId, accSensor);
            }
            serverAppState.addAVD(this.smartphoneId, avd);
            this.setState(PHATCommand.State.Success);
            return;
        }
        this.setState(PHATCommand.State.Fail);
    }

    public String getEmuOptions() {
        return this.emuOptions;
    }

    public SetAndroidEmulatorCommand setEmuOptions(String emuOptions) {
        this.emuOptions = emuOptions;
        return this;
    }

    public String getSmartphoneId() {
        return this.smartphoneId;
    }

    public String getAvdId() {
        return this.avdId;
    }

    public String getSerialEmulator() {
        return this.serialEmulator;
    }

    public void interruptCommand(Application app) {
        this.setState(PHATCommand.State.Interrupted);
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "(" + this.smartphoneId + ", " + this.avdId + ")";
    }
}

