/*
 * Decompiled with CFR 0.152.
 */
package phat.server.commands;

import com.jme3.app.Application;
import com.jme3.scene.Node;
import phat.commands.PHATCommand;
import phat.devices.DevicesAppState;
import phat.sensors.presence.PHATPresenceSensor;
import phat.server.PHATServerManager;
import phat.server.ServerAppState;
import phat.server.commands.PHATServerCommand;

public class CreateAllPresenceSensorServersCommand
extends PHATServerCommand {
    public CreateAllPresenceSensorServersCommand() {
        super(null);
    }

    public void runCommand(Application app) {
        DevicesAppState devicesAppState = (DevicesAppState)app.getStateManager().getState(DevicesAppState.class);
        ServerAppState serverAppState = (ServerAppState)app.getStateManager().getState(ServerAppState.class);
        PHATServerManager serverManager = serverAppState.getServerManager();
        devicesAppState.registerAllAndroidDevicesInScenario();
        for (String deviceId : devicesAppState.getDeviceIds()) {
            PHATPresenceSensor ps;
            Node device = devicesAppState.getDevice(deviceId);
            String type = (String)device.getUserData("ROLE");
            String sensorID = deviceId;
            if (type == null || !type.equals("PresenceSensor") || (ps = (PHATPresenceSensor)device.getControl(PHATPresenceSensor.class)) == null) continue;
            serverManager.createAndStartPresenceServer(deviceId, sensorID, ps);
        }
        this.setState(PHATCommand.State.Success);
    }

    public void interruptCommand(Application app) {
        this.setState(PHATCommand.State.Interrupted);
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "()";
    }
}

