/*
 * Decompiled with CFR 0.152.
 */
package phat.server.commands;

import com.jme3.app.Application;
import com.jme3.scene.Node;
import java.util.logging.Level;
import phat.commands.PHATCommand;
import phat.commands.PHATCommandListener;
import phat.devices.DevicesAppState;
import phat.sensors.accelerometer.AccelerometerControl;
import phat.server.PHATServerManager;
import phat.server.ServerAppState;
import phat.server.accelerometer.TCPAccelerometerServer;
import phat.server.commands.PHATServerCommand;

public class ActivateAccelerometerServerCommand
extends PHATServerCommand {
    private String sensorID;
    private String sensorGroupID;

    public ActivateAccelerometerServerCommand(String sensorgroupID, String sensorID) {
        this(sensorgroupID, sensorID, null);
    }

    public ActivateAccelerometerServerCommand(String sensorgroupID, String sensorID, PHATCommandListener listener) {
        super(listener);
        this.sensorID = sensorID;
        this.sensorGroupID = sensorgroupID;
        logger.log(Level.INFO, "New Command: {0}", new Object[]{this});
    }

    public void runCommand(Application app) {
        DevicesAppState devicesAppState = (DevicesAppState)app.getStateManager().getState(DevicesAppState.class);
        ServerAppState serverAppState = (ServerAppState)app.getStateManager().getState(ServerAppState.class);
        devicesAppState.registerAllAndroidDevicesInScenario();
        Node device = devicesAppState.getDevice(this.sensorID);
        if (device != null) {
            PHATServerManager serverManager = serverAppState.getServerManager();
            AccelerometerControl accSensor = (AccelerometerControl)device.getControl(AccelerometerControl.class);
            if (accSensor != null) {
                TCPAccelerometerServer accServer = serverManager.createAndStartAccelerometerServer(this.sensorGroupID, this.sensorID, accSensor);
            }
            this.setState(PHATCommand.State.Success);
            return;
        }
        this.setState(PHATCommand.State.Fail);
    }

    public String getSensorId() {
        return this.sensorID;
    }

    public void interruptCommand(Application app) {
        this.setState(PHATCommand.State.Interrupted);
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "(" + this.sensorGroupID + "," + this.sensorID + ")";
    }
}

