/*
 * Decompiled with CFR 0.152.
 */
package phat.server.camera;

import com.jme3.app.state.AppState;
import com.jme3.asset.AssetManager;
import com.jme3.asset.TextureKey;
import com.jme3.audio.AudioRenderer;
import com.jme3.bullet.BulletAppState;
import com.jme3.bullet.control.RigidBodyControl;
import com.jme3.input.controls.ActionListener;
import com.jme3.input.controls.InputListener;
import com.jme3.input.controls.KeyTrigger;
import com.jme3.input.controls.Trigger;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.renderer.Camera;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.ViewPort;
import com.jme3.scene.CameraNode;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.control.CameraControl;
import com.jme3.scene.control.Control;
import com.jme3.scene.shape.Quad;
import com.jme3.system.AppSettings;
import com.jme3.texture.Texture;
import com.jme3.util.TempVars;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFrame;
import phat.devices.DevicesAppState;
import phat.devices.smartphone.SmartPhoneFactory;
import phat.server.ServerAppState;
import phat.server.commands.DisplayAVDScreenCommand;
import phat.server.commands.SetAndroidEmulatorCommand;
import phat.server.commands.StartActivityCommand;
import phat.util.Debug;
import phat.util.SimpleScenario;
import phat.util.SpatialFactory;

public class ZxingTest
extends SimpleScenario {
    DevicesAppState devicesAppState;
    ServerAppState serverAppState;
    Geometry screen;
    Vector3f screenLoc;
    Vector3f qrInitialPos = new Vector3f(0.0f, 1.0f, 1.0f);
    float step = 0.01f;
    float qrSize = 0.1f;
    float initialDistance = 1.2f;
    float MIN_ANGLE = -45.0f;
    float MAX_ANGLE = 45.0f;
    float incAngle = 22.5f;
    float currentAngle = 0.0f;
    Action nextAction;
    List<JFrame> frames = new ArrayList<JFrame>();
    Node smartphone;
    private ActionListener actionListener = new ActionListener(){

        public void onAction(String name, boolean keyPressed, float tpf) {
            if (keyPressed) {
                ZxingTest.this.nextAction = Action.valueOf(name);
            }
        }
    };

    public static void main(String[] args) {
        Logger.getGlobal().setLevel(Level.ALL);
        ZxingTest app = new ZxingTest();
        app.setPauseOnLostFocus(false);
        app.setShowSettings(false);
        AppSettings settings = new AppSettings(true);
        settings.setWidth(480);
        settings.setHeight(800);
        app.setSettings(settings);
        app.start();
    }

    public void simpleInitApp() {
        SmartPhoneFactory.init((BulletAppState)this.bulletAppState, (AssetManager)this.assetManager, (RenderManager)this.renderManager, (Camera)this.cam, (AudioRenderer)this.audioRenderer);
        this.devicesAppState = new DevicesAppState();
        this.stateManager.attach((AppState)this.devicesAppState);
        this.serverAppState = new ServerAppState();
        this.stateManager.attach((AppState)this.serverAppState);
        super.simpleInitApp();
        this.viewPort.setBackgroundColor(ColorRGBA.White);
        this.initKeys();
        this.serverAppState.runCommand(new SetAndroidEmulatorCommand("Smartphone1", "Smartphone1", "emulator-5554"));
        this.serverAppState.runCommand(new StartActivityCommand("Smartphone1", "phat.android.apps.camera", "CameraCaptureActivity"));
        DisplayAVDScreenCommand displayCommand = new DisplayAVDScreenCommand("Smartphone1", "Smartphone1");
        displayCommand.setFrecuency(0.5f);
        this.serverAppState.runCommand(displayCommand);
    }

    private void initKeys() {
        this.inputManager.addMapping(Action.Forward.name(), new Trigger[]{new KeyTrigger(200)});
        this.inputManager.addMapping(Action.Backward.name(), new Trigger[]{new KeyTrigger(208)});
        this.inputManager.addMapping(Action.Next.name(), new Trigger[]{new KeyTrigger(205)});
        this.inputManager.addMapping(Action.Previous.name(), new Trigger[]{new KeyTrigger(203)});
        this.inputManager.addListener((InputListener)this.actionListener, new String[]{Action.Forward.name()});
        this.inputManager.addListener((InputListener)this.actionListener, new String[]{Action.Backward.name()});
        this.inputManager.addListener((InputListener)this.actionListener, new String[]{Action.Next.name()});
        this.inputManager.addListener((InputListener)this.actionListener, new String[]{Action.Previous.name()});
    }

    public void createTerrain() {
        Debug.enableDebugGrid((float)10.0f, (AssetManager)this.assetManager, (Node)this.rootNode);
        Vector3f dimensions = new Vector3f(10.0f, 0.1f, 10.0f);
        Geometry floor = SpatialFactory.createCube((Vector3f)dimensions, (ColorRGBA)ColorRGBA.Gray);
        RigidBodyControl rbc = new RigidBodyControl(0.0f);
        floor.setLocalTranslation(new Vector3f(0.0f, -0.1f, 0.0f));
        floor.addControl((Control)rbc);
        this.bulletAppState.getPhysicsSpace().add((Object)rbc);
        this.rootNode.attachChild((Spatial)floor);
    }

    public void simpleUpdate(float tpf) {
        super.simpleUpdate(tpf);
        if (this.nextAction == null) {
            return;
        }
        switch (this.nextAction) {
            case Forward: {
                this.moveForward();
                System.out.println("Forwared!");
                break;
            }
            case Backward: {
                this.moveBackward();
                System.out.println("Backward!");
                break;
            }
            case Next: {
                if (this.currentAngle + this.incAngle <= this.MAX_ANGLE) {
                    this.currentAngle += this.incAngle;
                }
                this.initialPos();
                System.out.println("Next!");
                break;
            }
            case Previous: {
                if (this.currentAngle - this.incAngle >= this.MIN_ANGLE) {
                    this.currentAngle -= this.incAngle;
                }
                this.initialPos();
                System.out.println("Previous!");
                break;
            }
        }
        this.nextAction = null;
    }

    float distanceToScreen() {
        return this.smartphone.getWorldTranslation().distance(this.screenLoc);
    }

    void moveForward() {
        Vector3f dir = this.screenLoc.subtract(this.smartphone.getLocalTranslation());
        dir.normalizeLocal();
        dir.multLocal(this.step);
        this.smartphone.move(dir);
        System.out.println("d = " + this.distanceToScreen());
    }

    void moveBackward() {
        Vector3f dir = this.screenLoc.subtract(this.smartphone.getLocalTranslation());
        dir.normalizeLocal();
        dir.multLocal(this.step);
        dir.negateLocal();
        this.smartphone.move(dir);
        System.out.println("d = " + this.distanceToScreen());
    }

    void initialPos() {
        TempVars vars = TempVars.get();
        Quaternion q = vars.quat1;
        q.fromAngles(0.0f, (float)Math.PI / 180 * this.currentAngle, 0.0f);
        Vector3f dir = new Vector3f(0.0f, 0.0f, 1.0f);
        q.mult(dir, dir);
        vars.release();
        this.smartphone.setLocalTranslation(this.screenLoc.add(dir.mult(this.initialDistance)));
        this.smartphone.lookAt(this.screenLoc, Vector3f.UNIT_Y);
        System.out.println("smartphone.loc = " + this.smartphone.getWorldTranslation());
    }

    public void createOtherObjects() {
        Node screenNode = new Node();
        Quad quadMesh = new Quad(1.0f, 1.0f);
        quadMesh.updateGeometry(1.0f, 1.0f, true);
        this.screen = new Geometry("Textured Quad", (Mesh)quadMesh);
        screenNode.attachChild((Spatial)this.screen);
        TextureKey key = new TextureKey("Textures/PHAT-QR.png", false);
        key.setGenerateMips(true);
        Texture tex = this.assetManager.loadTexture(key);
        Material mat = new Material(this.assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
        mat.setTexture("ColorMap", tex);
        this.screen.setMaterial(mat);
        this.screen.setLocalScale(new Vector3f(this.qrSize, this.qrSize, 1.0f));
        this.screen.center();
        this.screen.move(this.qrInitialPos);
        screenNode.lookAt(new Vector3f(0.0f, 0.0f, 1.0f), Vector3f.UNIT_Y);
        this.rootNode.attachChild((Spatial)screenNode);
        this.createSmartphone("Smartphone1", new Vector3f(0.0f, 0.0f, 0.0f), ColorRGBA.Cyan);
    }

    protected void createCameras() {
        this.flyCam.setMoveSpeed(1.0f);
        this.flyCam.setDragToRotate(true);
        this.cam.setFrustumPerspective(45.0f, (float)this.cam.getWidth() / (float)this.cam.getHeight(), 0.01f, 1000.0f);
        Vector3f center = this.screen.getModelBound().getCenter();
        center.multLocal(this.qrSize);
        this.screenLoc = this.screen.getWorldTranslation().add(center);
        this.initialPos();
    }

    private void createSmartphone(String smartphoneId, Vector3f loc, ColorRGBA color) {
        this.smartphone = SmartPhoneFactory.createSmartphone((String)smartphoneId, (Vector3f)new Vector3f(0.048f, 0.08f, 0.002f));
        this.smartphone.removeControl(RigidBodyControl.class);
        this.smartphone.setLocalTranslation(loc);
        this.smartphone.attachChild((Spatial)this.smartphone);
        this.smartphone.setName(smartphoneId);
        SmartPhoneFactory.enableCameraFacility((Node)this.smartphone);
        this.devicesAppState.addDevice(smartphoneId, this.smartphone);
        this.rootNode.attachChild((Spatial)this.smartphone);
    }

    private ViewPort createViewPort(Camera smartPhoneCamera) {
        float xFactor = (float)this.cam.getWidth() / (float)smartPhoneCamera.getWidth();
        float yFactor = (float)this.cam.getHeight() / (float)smartPhoneCamera.getHeight();
        smartPhoneCamera.setViewPort(0.0f * xFactor, 1.0f * xFactor, 0.0f * yFactor, 1.0f * yFactor);
        ViewPort vp = this.renderManager.createPreView("asdf", smartPhoneCamera);
        vp.setClearFlags(true, true, true);
        vp.setBackgroundColor(ColorRGBA.White);
        vp.attachScene((Spatial)SpatialFactory.getRootNode());
        return vp;
    }

    private CameraNode createCameraNode(Camera smartPhoneCamera) {
        CameraNode camNode = new CameraNode("Camera Node", smartPhoneCamera);
        camNode.setControlDir(CameraControl.ControlDirection.SpatialToCamera);
        camNode.setLocalTranslation(new Vector3f(0.0f, 0.0f, 0.0f));
        return camNode;
    }

    public void destroy() {
        super.destroy();
        for (JFrame f : this.frames) {
            f.dispose();
        }
    }

    public static enum Action {
        Forward,
        Backward,
        Next,
        Previous;

    }
}

