/*
 * Decompiled with CFR 0.152.
 */
package phat.server.camera;

import java.awt.image.BufferedImage;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.logging.Level;
import java.util.logging.Logger;
import phat.sensors.Sensor;
import phat.sensors.SensorData;
import phat.sensors.SensorListener;
import phat.sensors.camera.CameraSensor;
import phat.sensors.camera.CameraSensorData;
import phat.server.TCPSensorServer;
import phat.server.microphone.TCPAudioMicroServer;
import phat.util.PHATImageUtils;
import sim.android.hardware.service.CameraImageCapture;

public class TCPCameraSensorServer
implements SensorListener,
TCPSensorServer {
    protected ServerSocket serverSocket;
    protected ObjectOutputStream oos;
    private String ip;
    private int port;
    private Thread serverThread;
    private Socket socket;
    private boolean endServer = false;
    int imgSending = 0;
    static final int IMG_BUFFER = 20;
    final Object mutex0 = new Object();
    final Object mutex1 = new Object();
    final Object mutex2 = new Object();
    CameraSensor cameraSensor;
    float rate = 1.0f;
    float lastTime = 0.0f;
    int counter = 0;

    public TCPCameraSensorServer(InetAddress ip, int port, CameraSensor cameraSensor) throws IOException {
        this.ip = ip.getHostAddress();
        this.port = port;
        this.cameraSensor = cameraSensor;
        this.serverSocket = new ServerSocket(port, 0, ip);
    }

    @Override
    public String getIp() {
        return this.ip;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public void start() {
        this.serverThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    while (!TCPCameraSensorServer.this.endServer) {
                        try {
                            Socket socket = TCPCameraSensorServer.this.serverSocket.accept();
                            socket.setSendBufferSize(30720000);
                            System.out.println("*Nuevo Cliente: " + socket);
                            TCPCameraSensorServer.this.upClient(socket);
                        }
                        catch (SocketException ex) {
                            if (TCPCameraSensorServer.this.endServer) continue;
                            Logger.getLogger(TCPAudioMicroServer.class.getName()).log(Level.SEVERE, null, ex);
                        }
                    }
                }
                catch (IOException ex) {
                    Logger.getLogger(TCPCameraSensorServer.class.getName()).log(Level.SEVERE, null, ex);
                    TCPCameraSensorServer.this.socket = null;
                    TCPCameraSensorServer.this.oos = null;
                }
            }
        });
        this.serverThread.start();
    }

    private synchronized void upClient(Socket socket) {
        this.socket = socket;
        this.cameraSensor.add((SensorListener)this);
        try {
            this.oos = new ObjectOutputStream(socket.getOutputStream());
        }
        catch (IOException ex) {
            Logger.getLogger(TCPCameraSensorServer.class.getName()).log(Level.SEVERE, null, ex);
            this.oos = null;
            this.socket = null;
        }
    }

    @Override
    public void stop() {
        this.cameraSensor.remove((SensorListener)this);
        try {
            this.endServer = true;
            this.serverSocket.close();
            if (this.oos != null) {
                this.oos.close();
                this.oos = null;
            }
            if (this.socket != null) {
                this.socket.close();
                this.socket = null;
            }
        }
        catch (IOException e1) {
            Logger.getLogger(this.getClass().getSimpleName()).log(Level.SEVERE, null, e1);
        }
    }

    private boolean isTimeToSend(CameraSensorData csd) {
        this.lastTime += csd.getFps();
        if (this.lastTime > this.rate) {
            this.lastTime = 0.0f;
            return true;
        }
        return false;
    }

    private void saveFile(byte[] data) {
        try {
            FileOutputStream fos = new FileOutputStream("capture-" + this.counter++ + ".bmp");
            fos.write(data);
            fos.close();
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(TCPCameraSensorServer.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(TCPCameraSensorServer.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(Sensor source, SensorData sd) {
        if (this.socket == null || this.oos == null) {
            return;
        }
        if (source instanceof CameraSensor && sd instanceof CameraSensorData) {
            CameraImageCapture cic;
            CameraSensor cs = (CameraSensor)source;
            CameraSensorData csd = (CameraSensorData)sd;
            Object object = this.mutex0;
            synchronized (object) {
                if (this.imgSending >= 2) {
                    return;
                }
                ++this.imgSending;
            }
            Object object2 = this.mutex1;
            synchronized (object2) {
                byte[] buf = PHATImageUtils.bufferedImageToFormat((BufferedImage)csd.getImage(), (String)"PNG");
                cic = new CameraImageCapture(0L, buf, csd.getWidth(), csd.getHeigh(), csd.getImage().getType());
            }
            object2 = this.mutex2;
            synchronized (object2) {
                this.send(cic);
            }
            object2 = this.mutex0;
            synchronized (object2) {
                --this.imgSending;
            }
        }
    }

    private void send(CameraImageCapture cic) {
        try {
            this.oos.writeObject(cic);
            this.oos.flush();
            this.oos.reset();
        }
        catch (IOException e1) {
            Logger.getLogger(this.getClass().getSimpleName()).log(Level.SEVERE, null, e1);
            this.socket = null;
            this.oos = null;
        }
    }

    public float getRate() {
        return this.rate;
    }

    public void setRate(float rate) {
        this.rate = rate;
    }

    public void cleanUp() {
        this.stop();
    }
}

