/*
 * Decompiled with CFR 0.152.
 */
package phat.server.microphone;

import com.aurellem.capture.AurellemSystemDelegate;
import com.aurellem.capture.IsoTimer;
import com.jme3.app.SimpleApplication;
import com.jme3.asset.AssetManager;
import com.jme3.asset.plugins.FileLocator;
import com.jme3.audio.AudioRenderer;
import com.jme3.audio.AudioSource;
import com.jme3.cinematic.MotionPath;
import com.jme3.cinematic.events.AbstractCinematicEvent;
import com.jme3.cinematic.events.MotionEvent;
import com.jme3.cinematic.events.MotionTrack;
import com.jme3.light.AmbientLight;
import com.jme3.light.DirectionalLight;
import com.jme3.light.Light;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.control.Control;
import com.jme3.scene.shape.Box;
import com.jme3.scene.shape.Sphere;
import com.jme3.system.AppSettings;
import com.jme3.system.JmeSystem;
import com.jme3.system.JmeSystemDelegate;
import com.jme3.system.Timer;
import java.lang.reflect.Field;
import org.lwjgl.input.Mouse;
import phat.audio.AudioFactory;
import phat.audio.AudioSpeakerSource;
import phat.sensors.microphone.MicrophoneControl;
import phat.server.PHATServerManager;

public class TestAdvancedAudio
extends SimpleApplication {
    private Geometry bell;
    private AudioSpeakerSource music;
    private MotionTrack motionControl;
    private IsoTimer motionTimer = new IsoTimer(60.0f);
    private MicrophoneControl micControl;
    private PHATServerManager serverManager;
    private Vector3f[] path = new Vector3f[]{new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.0f, -10.0f), new Vector3f(-2.0f, 0.0f, -14.0f), new Vector3f(-6.0f, 0.0f, -20.0f), new Vector3f(0.0f, 0.0f, -26.0f), new Vector3f(6.0f, 0.0f, -20.0f), new Vector3f(0.0f, 0.0f, -14.0f), new Vector3f(-6.0f, 0.0f, -20.0f), new Vector3f(0.0f, 0.0f, -26.0f), new Vector3f(6.0f, 0.0f, -20.0f), new Vector3f(5.0f, 0.0f, -5.0f), new Vector3f(7.0f, 0.0f, 1.5f), new Vector3f(14.0f, 0.0f, 2.0f), new Vector3f(20.0f, 0.0f, 6.0f), new Vector3f(26.0f, 0.0f, 0.0f), new Vector3f(20.0f, 0.0f, -6.0f), new Vector3f(14.0f, 0.0f, 0.0f), new Vector3f(20.0f, 0.0f, 6.0f), new Vector3f(26.0f, 0.0f, 0.0f), new Vector3f(20.0f, 0.0f, -6.0f), new Vector3f(14.0f, 0.0f, 0.0f), new Vector3f(8.0f, 0.0f, 7.5f), new Vector3f(7.0f, 0.0f, 10.5f), new Vector3f(6.0f, 0.0f, 20.0f), new Vector3f(0.0f, 0.0f, 26.0f), new Vector3f(-6.0f, 0.0f, 20.0f), new Vector3f(0.0f, 0.0f, 14.0f), new Vector3f(6.0f, 0.0f, 20.0f), new Vector3f(0.0f, 0.0f, 26.0f), new Vector3f(-6.0f, 0.0f, 20.0f), new Vector3f(0.0f, 0.0f, 14.0f), new Vector3f(16.0f, 5.0f, 20.0f), new Vector3f(0.0f, 0.0f, 26.0f), new Vector3f(-16.0f, -10.0f, 20.0f), new Vector3f(0.0f, 0.0f, 14.0f), new Vector3f(16.0f, 20.0f, 20.0f), new Vector3f(0.0f, 0.0f, 26.0f), new Vector3f(-10.0f, -25.0f, 10.0f), new Vector3f(-10.0f, 0.0f, 0.0f), new Vector3f(-28.00242f, 48.005623f, -34.648228f), new Vector3f(0.0f, 0.0f, -20.0f)};

    public static void main(String[] args) {
        TestAdvancedAudio app = new TestAdvancedAudio();
        AppSettings settings = new AppSettings(true);
        settings.setAudioRenderer("Send");
        JmeSystem.setSystemDelegate((JmeSystemDelegate)new AurellemSystemDelegate());
        app.setSettings(settings);
        app.setShowSettings(false);
        app.setPauseOnLostFocus(false);
        app.start();
    }

    private Geometry makeEar(Node root, Vector3f position) {
        Material mat = new Material(this.assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
        Geometry ear = new Geometry("ear", (Mesh)new Box(0.2f, 0.2f, 0.2f));
        ear.setLocalTranslation(position);
        mat.setColor("Color", ColorRGBA.Green);
        ear.setMaterial(mat);
        root.attachChild((Spatial)ear);
        return ear;
    }

    private void createScene() {
        Material mat = new Material(this.assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
        this.bell = new Geometry("sound-emitter", (Mesh)new Sphere(15, 15, 1.0f));
        mat.setColor("Color", ColorRGBA.Blue);
        this.bell.setMaterial(mat);
        this.rootNode.attachChild((Spatial)this.bell);
        MotionPath track = new MotionPath();
        for (Vector3f v : this.path) {
            track.addWayPoint(v);
        }
        track.setCurveTension(0.8f);
        this.motionControl = new MotionTrack((Spatial)this.bell, track);
        try {
            Field timerField = AbstractCinematicEvent.class.getDeclaredField("timer");
            timerField.setAccessible(true);
            try {
                timerField.set(this.motionControl, this.motionTimer);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        this.motionControl.setDirectionType(MotionEvent.Direction.PathAndRotation);
        this.motionControl.setRotation(new Quaternion().fromAngleNormalAxis(-1.5707964f, Vector3f.UNIT_Y));
        this.motionControl.setInitialDuration(20.0f);
        this.motionControl.setSpeed(0.1f);
        track.enableDebugShape(this.assetManager, this.rootNode);
        this.positionCamera();
    }

    private void positionCamera() {
        this.cam.setLocation(new Vector3f(-28.00242f, 48.005623f, -34.648228f));
        this.cam.setRotation(new Quaternion(0.3359635f, 0.34280345f, -0.13281013f, 0.8671653f));
    }

    private void initAudio() {
        Mouse.setGrabbed((boolean)false);
        this.assetManager.registerLocator("assets", FileLocator.class);
        AudioFactory.init((AudioRenderer)this.audioRenderer, (AssetManager)this.assetManager, (Node)this.rootNode);
        this.music = AudioFactory.getInstance().makeAudioSpeakerSource("Speaker1", "Help, I am hurt!", new Vector3f(15.0f, 1.0f, 2.0f));
        this.music.setLooping(true);
        this.music.setShowRange(true);
        this.rootNode.attachChild((Spatial)this.music);
        this.music.setPositional(true);
        this.music.setVolume(1.0f);
        this.music.setReverbEnabled(false);
        this.music.setDirectional(false);
        this.music.setMaxDistance(200.0f);
        this.music.setRefDistance(1.0f);
        this.audioRenderer.pauseSource((AudioSource)this.music);
    }

    public void simpleInitApp() {
        this.setDisplayStatView(false);
        this.setDisplayFps(false);
        this.setTimer((Timer)new IsoTimer(60.0f));
        this.initAudio();
        this.createScene();
        Geometry geo1 = this.makeEar(this.rootNode, new Vector3f(0.0f, 0.0f, -20.0f));
        this.micControl = new MicrophoneControl("Micro1", 10000, this.audioRenderer);
        geo1.addControl((Control)this.micControl);
        this.serverManager = new PHATServerManager();
        this.serverManager.createAndStartAudioMicroServer("device1", this.micControl);
        this.motionControl.play();
    }

    public void simpleUpdate(float tpf) {
        this.motionTimer.update();
        if (this.music.getStatus() != AudioSource.Status.Playing) {
            this.music.play();
        }
        Vector3f loc = this.cam.getLocation();
        Quaternion rot = this.cam.getRotation();
        this.listener.setLocation(loc);
        this.listener.setRotation(rot);
        this.music.setLocalTranslation(this.bell.getLocalTranslation());
    }

    private void createLight() {
        AmbientLight al = new AmbientLight();
        al.setColor(ColorRGBA.White.mult(0.5f));
        this.rootNode.addLight((Light)al);
        DirectionalLight dl = new DirectionalLight();
        dl.setColor(ColorRGBA.White);
        dl.setDirection(new Vector3f(2.8f, -2.8f, -2.8f).normalizeLocal());
        this.rootNode.addLight((Light)dl);
    }

    public void destroy() {
        super.destroy();
        System.out.println("destroy()");
        this.micControl.cleanUp();
    }
}

