/*
 * Decompiled with CFR 0.152.
 */
package phat.server.commands.tests;

import com.jme3.app.SimpleApplication;
import com.jme3.app.state.AppState;
import com.jme3.app.state.AppStateManager;
import com.jme3.asset.AssetManager;
import com.jme3.bullet.BulletAppState;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.scene.Node;
import com.jme3.system.AppSettings;
import java.util.logging.Logger;
import phat.app.PHATApplication;
import phat.app.PHATInitAppListener;
import phat.body.BodiesAppState;
import phat.body.commands.RandomWalkingCommand;
import phat.body.commands.SetBodyInCoordenatesCommand;
import phat.commands.PHATCommand;
import phat.devices.DevicesAppState;
import phat.devices.commands.CreateSmartphoneCommand;
import phat.devices.commands.PHATDeviceCommand;
import phat.devices.commands.SetDeviceOnFurnitureCommand;
import phat.devices.commands.SetDeviceOnPartOfBodyCommand;
import phat.structures.houses.TestHouse;
import phat.util.SpatialFactory;
import phat.world.WorldAppState;

public class SetDeviceOnPartOfBodyCommandTest
implements PHATInitAppListener {
    private static final Logger logger = Logger.getLogger(TestHouse.class.getName());
    BodiesAppState bodiesAppState;
    DevicesAppState devicesAppState;
    WorldAppState worldAppState;

    public static void main(String[] args) {
        SetDeviceOnPartOfBodyCommandTest test = new SetDeviceOnPartOfBodyCommandTest();
        PHATApplication phat = new PHATApplication((PHATInitAppListener)test);
        phat.setDisplayFps(true);
        phat.setDisplayStatView(false);
        AppSettings settings = new AppSettings(true);
        settings.setWidth(480);
        settings.setHeight(800);
        phat.setSettings(settings);
        phat.start();
    }

    public void init(SimpleApplication app) {
        SpatialFactory.init((AssetManager)app.getAssetManager(), (Node)app.getRootNode());
        AppStateManager stateManager = app.getStateManager();
        app.getFlyByCamera().setMoveSpeed(10.0f);
        app.getCamera().setLocation(new Vector3f(0.2599395f, 2.7232018f, 3.373138f));
        app.getCamera().setRotation(new Quaternion(-0.0035931943f, 0.9672268f, -0.25351822f, -0.013704466f));
        BulletAppState bulletAppState = new BulletAppState();
        stateManager.attach((AppState)bulletAppState);
        this.worldAppState = new WorldAppState();
        this.worldAppState.setLandType(WorldAppState.LandType.Grass);
        app.getStateManager().attach((AppState)this.worldAppState);
        this.worldAppState.setCalendar(2013, 1, 1, 12, 0, 0);
        this.bodiesAppState = new BodiesAppState();
        stateManager.attach((AppState)this.bodiesAppState);
        this.bodiesAppState.createBody(BodiesAppState.BodyType.ElderLP, "Patient");
        this.bodiesAppState.runCommand((PHATCommand)new SetBodyInCoordenatesCommand("Patient", Vector3f.ZERO));
        this.bodiesAppState.runCommand((PHATCommand)new RandomWalkingCommand("Patient", true));
        this.devicesAppState = new DevicesAppState();
        stateManager.attach((AppState)this.devicesAppState);
        this.devicesAppState.runCommand((PHATDeviceCommand)new CreateSmartphoneCommand("Smartphone1"));
        this.devicesAppState.runCommand((PHATDeviceCommand)new SetDeviceOnPartOfBodyCommand("Patient", "Smartphone1", SetDeviceOnPartOfBodyCommand.PartOfBody.Chest));
        this.devicesAppState.runCommand((PHATDeviceCommand)new CreateSmartphoneCommand("SmartWatch1").setDimensions(0.03f, 0.03f, 0.01f));
        this.devicesAppState.runCommand((PHATDeviceCommand)new SetDeviceOnPartOfBodyCommand("Patient", "SmartWatch1", SetDeviceOnPartOfBodyCommand.PartOfBody.LeftWrist));
        this.devicesAppState.runCommand((PHATDeviceCommand)new SetDeviceOnFurnitureCommand("deviceId", "House1", "furnitureId"));
    }
}

