/*
 * Decompiled with CFR 0.152.
 */
package phat.server.commands.tests;

import com.jme3.app.Application;
import com.jme3.app.SimpleApplication;
import com.jme3.app.state.AbstractAppState;
import com.jme3.app.state.AppState;
import com.jme3.app.state.AppStateManager;
import com.jme3.asset.AssetManager;
import com.jme3.bullet.BulletAppState;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.scene.Node;
import com.jme3.system.AppSettings;
import java.awt.Component;
import java.util.List;
import java.util.Random;
import java.util.logging.Logger;
import javax.swing.JFrame;
import javax.swing.JPanel;
import phat.app.PHATApplication;
import phat.app.PHATInitAppListener;
import phat.body.BodiesAppState;
import phat.body.commands.GoToSpaceCommand;
import phat.body.commands.SetBodyInHouseSpaceCommand;
import phat.body.commands.SetSpeedDisplacemenetCommand;
import phat.body.commands.TremblingHandCommand;
import phat.commands.PHATCommand;
import phat.commands.PHATCommandListener;
import phat.devices.DevicesAppState;
import phat.devices.commands.CreatePresenceSensorCommand;
import phat.devices.commands.PHATDeviceCommand;
import phat.sensors.SensorListener;
import phat.sensors.presence.PHATPresenceSensor;
import phat.sensors.presence.PresenceStatePanel;
import phat.server.ServerAppState;
import phat.server.commands.CreateAllPresenceSensorServersCommand;
import phat.structures.houses.HouseAppState;
import phat.structures.houses.HouseFactory;
import phat.structures.houses.TestHouse;
import phat.structures.houses.commands.CreateHouseCommand;
import phat.util.SpatialFactory;
import phat.world.WorldAppState;

public class SensorPresenceHouseTest
implements PHATInitAppListener,
PHATCommandListener {
    private static final Logger logger = Logger.getLogger(TestHouse.class.getName());
    BodiesAppState bodiesAppState;
    DevicesAppState devicesAppState;
    WorldAppState worldAppState;
    HouseAppState houseAppState;
    String bodyId = "Patient";
    String houseId = "House1";
    JFrame sensorMonitor;
    Random random = new Random();

    public static void main(String[] args) {
        SensorPresenceHouseTest test = new SensorPresenceHouseTest();
        PHATApplication phat = new PHATApplication((PHATInitAppListener)test);
        phat.setDisplayFps(true);
        phat.setDisplayStatView(false);
        AppSettings settings = new AppSettings(true);
        settings.setTitle("PHAT");
        settings.setWidth(1280);
        settings.setHeight(960);
        phat.setSettings(settings);
        phat.start();
    }

    public void init(SimpleApplication app) {
        SpatialFactory.init((AssetManager)app.getAssetManager(), (Node)app.getRootNode());
        AppStateManager stateManager = app.getStateManager();
        app.getFlyByCamera().setMoveSpeed(10.0f);
        app.getCamera().setLocation(new Vector3f(0.2599395f, 2.7232018f, 3.373138f));
        app.getCamera().setRotation(new Quaternion(-0.0035931943f, 0.9672268f, -0.25351822f, -0.013704466f));
        BulletAppState bulletAppState = new BulletAppState();
        bulletAppState.setThreadingType(BulletAppState.ThreadingType.PARALLEL);
        stateManager.attach((AppState)bulletAppState);
        bulletAppState.getPhysicsSpace().setAccuracy(0.016666668f);
        this.worldAppState = new WorldAppState();
        this.worldAppState.setLandType(WorldAppState.LandType.Grass);
        app.getStateManager().attach((AppState)this.worldAppState);
        this.worldAppState.setCalendar(2013, 1, 1, 12, 0, 0);
        this.houseAppState = new HouseAppState();
        this.houseAppState.runCommand((PHATCommand)new CreateHouseCommand(this.houseId, HouseFactory.HouseType.House3room2bath));
        app.getStateManager().attach((AppState)this.houseAppState);
        this.bodiesAppState = new BodiesAppState();
        stateManager.attach((AppState)this.bodiesAppState);
        this.bodiesAppState.createBody(BodiesAppState.BodyType.Elder, this.bodyId);
        this.bodiesAppState.runCommand((PHATCommand)new SetBodyInHouseSpaceCommand(this.bodyId, this.houseId, "Kitchen"));
        this.bodiesAppState.runCommand((PHATCommand)new TremblingHandCommand(this.bodyId, Boolean.valueOf(true), Boolean.valueOf(true)));
        this.bodiesAppState.runCommand((PHATCommand)new SetSpeedDisplacemenetCommand(this.bodyId, 1.5f));
        this.devicesAppState = new DevicesAppState();
        stateManager.attach((AppState)this.devicesAppState);
        this.sensorMonitor = new JFrame("Sensor Monitoring");
        JPanel content = new JPanel();
        this.sensorMonitor.setContentPane(content);
        this.createPrenceSensor("PreSen-Bedroom1-1");
        this.createPrenceSensor("PreSen-Kitchen-1");
        this.createPrenceSensor("PreSen-Hall-4");
        this.createPrenceSensor("PreSen-Bathroom1-1");
        this.createPrenceSensor("PreSen-Living-1");
        this.createPrenceSensor("PreSen-Living-3");
        this.sensorMonitor.setVisible(true);
        ServerAppState serverAppState = new ServerAppState();
        stateManager.attach((AppState)serverAppState);
        serverAppState.runCommand(new CreateAllPresenceSensorServersCommand());
        stateManager.attach((AppState)new AbstractAppState(){
            PHATApplication app;
            boolean standUp = false;
            boolean washingHands = false;
            boolean havingShower = false;
            float cont = 0.0f;
            float timeToStandUp = 5.0f;
            boolean init = false;

            public void initialize(AppStateManager asm, Application aplctn) {
                this.app = (PHATApplication)aplctn;
            }

            public void update(float f) {
                if (!this.init) {
                    this.init = true;
                    SensorPresenceHouseTest.this.bodiesAppState.runCommand((PHATCommand)SensorPresenceHouseTest.this.goToRandomRoom());
                }
            }
        });
    }

    private CreatePresenceSensorCommand createPrenceSensor(String id) {
        CreatePresenceSensorCommand cpsc = new CreatePresenceSensorCommand(id, (PHATCommandListener)this);
        cpsc.setEnableDebug(true);
        cpsc.sethAngle(90.0f);
        cpsc.setvAngle(45.0f);
        cpsc.setAngleStep(10.0f);
        this.devicesAppState.runCommand((PHATDeviceCommand)cpsc);
        return cpsc;
    }

    public void commandStateChanged(PHATCommand command) {
        PHATPresenceSensor psControl;
        CreatePresenceSensorCommand cpsc;
        Node psNode;
        if (command instanceof CreatePresenceSensorCommand && (psNode = this.devicesAppState.getDevice((cpsc = (CreatePresenceSensorCommand)command).getPresenceSensorId())) != null && (psControl = (PHATPresenceSensor)psNode.getControl(PHATPresenceSensor.class)) != null) {
            PresenceStatePanel psp1 = new PresenceStatePanel();
            psControl.add((SensorListener)psp1);
            this.sensorMonitor.getContentPane().add((Component)psp1);
            this.sensorMonitor.pack();
        }
    }

    private GoToSpaceCommand goToRandomRoom() {
        List roomNames = this.houseAppState.getHouse(this.houseId).getRoomNames();
        int size = roomNames.size();
        int index = this.random.nextInt(size);
        return new GoToSpaceCommand(this.bodyId, (String)roomNames.get(index), new PHATCommandListener(){

            public void commandStateChanged(PHATCommand command) {
                if (command.getState().equals((Object)PHATCommand.State.Success)) {
                    SensorPresenceHouseTest.this.bodiesAppState.runCommand((PHATCommand)SensorPresenceHouseTest.this.goToRandomRoom());
                } else if (command.getState().equals((Object)PHATCommand.State.Fail)) {
                    SensorPresenceHouseTest.this.bodiesAppState.runCommand((PHATCommand)SensorPresenceHouseTest.this.goToRandomRoom());
                }
            }
        });
    }
}

