/*
 * Decompiled with CFR 0.152.
 */
package phat.server.commands.tests;

import com.jme3.app.SimpleApplication;
import com.jme3.app.state.AppState;
import com.jme3.app.state.AppStateManager;
import com.jme3.asset.AssetManager;
import com.jme3.audio.AudioRenderer;
import com.jme3.bullet.BulletAppState;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.renderer.Camera;
import com.jme3.renderer.RenderManager;
import java.util.logging.Logger;
import phat.app.PHATApplication;
import phat.app.PHATInitAppListener;
import phat.commands.PHATCommand;
import phat.devices.DevicesAppState;
import phat.devices.commands.CreateSmartphoneCommand;
import phat.devices.commands.PHATDeviceCommand;
import phat.devices.smartphone.SmartPhoneFactory;
import phat.environment.SpatialEnvironmentAPI;
import phat.server.ServerAppState;
import phat.server.commands.DisplayAVDScreenCommand;
import phat.server.commands.SetAndroidEmulatorCommand;
import phat.server.commands.StartActivityCommand;
import phat.structures.houses.HouseFactory;
import phat.structures.houses.TestHouse;
import phat.structures.houses.commands.CreateHouseCommand;
import phat.world.WorldAppState;

public class CreateAndroidTVTest
implements PHATInitAppListener {
    private static final Logger logger = Logger.getLogger(TestHouse.class.getName());
    DevicesAppState devicesAppState;
    ServerAppState serverAppState;
    SpatialEnvironmentAPI seAPI;

    public static void main(String[] args) {
        CreateAndroidTVTest test = new CreateAndroidTVTest();
        PHATApplication phat = new PHATApplication((PHATInitAppListener)test);
        phat.setDisplayFps(true);
        phat.setDisplayStatView(false);
        phat.start();
    }

    public void init(SimpleApplication app) {
        AppStateManager stateManager = app.getStateManager();
        app.getFlyByCamera().setMoveSpeed(10.0f);
        SmartPhoneFactory.camera = app.getCamera();
        SmartPhoneFactory.camera.setFrustumPerspective(45.0f, (float)SmartPhoneFactory.camera.getWidth() / (float)SmartPhoneFactory.camera.getHeight(), 0.1f, 1000.0f);
        app.getCamera().setLocation(new Vector3f(4.497525f, 6.3693237f, 4.173162f));
        app.getCamera().setRotation(new Quaternion(0.5199084f, 0.42191547f, -0.32954147f, 0.6656463f));
        this.seAPI = SpatialEnvironmentAPI.createSpatialEnvironmentAPI((SimpleApplication)app);
        this.seAPI.getWorldAppState().setCalendar(2013, 1, 1, 12, 0, 0);
        this.seAPI.getWorldAppState().setLandType(WorldAppState.LandType.Basic);
        this.seAPI.getHouseAppState().runCommand((PHATCommand)new CreateHouseCommand("House1", HouseFactory.HouseType.House3room2bath));
        BulletAppState bulletAppState = (BulletAppState)app.getStateManager().getState(BulletAppState.class);
        SmartPhoneFactory.init((BulletAppState)bulletAppState, (AssetManager)app.getAssetManager(), (RenderManager)app.getRenderManager(), (Camera)app.getCamera(), (AudioRenderer)app.getAudioRenderer());
        this.devicesAppState = new DevicesAppState();
        stateManager.attach((AppState)this.devicesAppState);
        String deviceId = "AndroidTV1";
        String avdId = "AndroidTV1";
        this.devicesAppState.runCommand((PHATDeviceCommand)new CreateSmartphoneCommand(deviceId));
        this.serverAppState = new ServerAppState();
        stateManager.attach((AppState)this.serverAppState);
        this.serverAppState.runCommand(new SetAndroidEmulatorCommand(deviceId, avdId, "emulator-5554"));
        this.serverAppState.runCommand(new StartActivityCommand(deviceId, "es.ucm.fdi.grasia.smarttvapp.gui", "TVAppActivity"));
        DisplayAVDScreenCommand displayCommand = new DisplayAVDScreenCommand(deviceId, avdId);
        displayCommand.setFrecuency(0.5f);
        this.serverAppState.runCommand(displayCommand);
    }
}

