/*
 * Decompiled with CFR 0.152.
 */
package phat.devices.controls;

import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.ViewPort;
import com.jme3.scene.Geometry;
import com.jme3.scene.Spatial;
import com.jme3.scene.control.AbstractControl;
import com.jme3.scene.control.Control;
import com.jme3.texture.Image;
import com.jme3.texture.Texture;
import com.jme3.texture.Texture2D;
import com.jme3.texture.plugins.AWTLoader;
import java.awt.image.BufferedImage;
import java.io.IOException;
import phat.mobile.adm.AndroidVirtualDevice;

public class ScreenAVDControl
extends AbstractControl {
    float frecuency = 1.0f;
    float cont = 0.0f;
    AndroidVirtualDevice avd;
    Geometry display;
    Texture texture;
    AWTLoader awtLoader;
    final BufferedImage[] buf = new BufferedImage[2];
    int index = -1;
    int imagCont = 0;
    Thread imageCapture;
    boolean finish;

    public ScreenAVDControl(Geometry display, AndroidVirtualDevice avd) {
        this.display = display;
        this.avd = avd;
    }

    public void setSpatial(Spatial spatial) {
        super.setSpatial(spatial);
        if (spatial != null) {
            this.awtLoader = new AWTLoader();
            this.imageCapture = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 * Converted monitor instructions to comments
                 * Lifted jumps to return sites
                 */
                @Override
                public void run() {
                    while (!ScreenAVDControl.this.finish) {
                        long t1 = System.currentTimeMillis();
                        BufferedImage bi = ScreenAVDControl.this.avd.takeSnapshot();
                        long t2 = System.currentTimeMillis();
                        System.out.println("takeSnapshot Time = " + (t2 - t1));
                        BufferedImage[] bufferedImageArray = ScreenAVDControl.this.buf;
                        // MONITORENTER : ScreenAVDControl.this.buf
                        if (ScreenAVDControl.this.index == -1) {
                            ScreenAVDControl.this.index = 0;
                            ScreenAVDControl.this.buf[0] = bi;
                        } else {
                            ScreenAVDControl.this.index = (ScreenAVDControl.this.index + 1) % 2;
                            ScreenAVDControl.this.buf[ScreenAVDControl.this.index] = bi;
                        }
                        ++ScreenAVDControl.this.imagCont;
                        // MONITOREXIT : bufferedImageArray
                    }
                }
            };
            this.imageCapture.start();
        } else {
            this.finish = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void controlUpdate(float fps) {
        this.cont += fps;
        if (!(this.cont > this.frecuency)) return;
        BufferedImage[] bufferedImageArray = this.buf;
        synchronized (this.buf) {
            if (this.imagCont > 0) {
                if (this.texture == null) {
                    this.texture = new Texture2D(this.buf[this.index].getWidth(), this.buf[this.index].getHeight(), Image.Format.Depth24);
                    this.texture.setImage(this.awtLoader.load(this.buf[this.index], true));
                    this.display.getMaterial().setTexture("ColorMap", this.texture);
                } else {
                    this.texture.setImage(this.awtLoader.load(this.buf[this.index], true));
                    this.display.updateGeometricState();
                }
                --this.imagCont;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.cont = 0.0f;
            return;
        }
    }

    protected void controlRender(RenderManager rm, ViewPort vp) {
    }

    public Control cloneForSpatial(Spatial sptl) {
        return new ScreenAVDControl(this.display, this.avd);
    }

    public void write(JmeExporter ex) throws IOException {
        super.write(ex);
    }

    public void read(JmeImporter im) throws IOException {
        super.read(im);
    }

    public float getFrecuency() {
        return this.frecuency;
    }

    public void setFrecuency(float frecuency) {
        this.frecuency = frecuency;
    }
}

