/*
 * Decompiled with CFR 0.152.
 */
package phat.server.commands.tests;

import com.jme3.app.Application;
import com.jme3.app.SimpleApplication;
import com.jme3.app.state.AbstractAppState;
import com.jme3.app.state.AppState;
import com.jme3.app.state.AppStateManager;
import com.jme3.asset.AssetManager;
import com.jme3.bullet.BulletAppState;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.scene.Node;
import com.jme3.system.AppSettings;
import java.util.logging.Logger;
import phat.app.PHATApplication;
import phat.app.PHATInitAppListener;
import phat.body.BodiesAppState;
import phat.body.commands.FallDownCommand;
import phat.body.commands.RandomWalkingCommand;
import phat.body.commands.SetBodyInCoordenatesCommand;
import phat.body.commands.SetCameraToBodyCommand;
import phat.body.commands.SetSpeedDisplacemenetCommand;
import phat.body.commands.SetStoopedBodyCommand;
import phat.body.commands.StandUpCommand;
import phat.body.commands.TremblingHandCommand;
import phat.body.commands.TremblingHeadCommand;
import phat.commands.PHATCommand;
import phat.devices.DevicesAppState;
import phat.devices.commands.CreateSmartphoneCommand;
import phat.devices.commands.PHATDeviceCommand;
import phat.devices.commands.SetDeviceOnPartOfBodyCommand;
import phat.sensors.SensorListener;
import phat.sensors.accelerometer.AccelerometerControl;
import phat.sensors.accelerometer.XYAccelerationsChart;
import phat.server.ServerAppState;
import phat.server.commands.DisplayAVDScreenCommand;
import phat.server.commands.SetAndroidEmulatorCommand;
import phat.server.commands.StartActivityCommand;
import phat.structures.houses.TestHouse;
import phat.util.Debug;
import phat.util.SpatialFactory;
import phat.world.WorldAppState;

public class AccelerometerParkinsonTest
implements PHATInitAppListener {
    private static final Logger logger = Logger.getLogger(TestHouse.class.getName());
    BodiesAppState bodiesAppState;
    ServerAppState serverAppState;
    DevicesAppState devicesAppState;
    WorldAppState worldAppState;

    public static void main(String[] args) {
        AccelerometerParkinsonTest test = new AccelerometerParkinsonTest();
        PHATApplication phat = new PHATApplication((PHATInitAppListener)test);
        phat.setDisplayFps(true);
        phat.setDisplayStatView(false);
        AppSettings settings = new AppSettings(true);
        settings.setTitle("PHAT");
        settings.setWidth(640);
        settings.setHeight(480);
        phat.setSettings(settings);
        phat.start();
    }

    public void init(SimpleApplication app) {
        SpatialFactory.init((AssetManager)app.getAssetManager(), (Node)app.getRootNode());
        AppStateManager stateManager = app.getStateManager();
        app.getFlyByCamera().setMoveSpeed(10.0f);
        app.getCamera().setLocation(new Vector3f(0.2599395f, 2.7232018f, 3.373138f));
        app.getCamera().setRotation(new Quaternion(-0.0035931943f, 0.9672268f, -0.25351822f, -0.013704466f));
        BulletAppState bulletAppState = new BulletAppState();
        bulletAppState.setThreadingType(BulletAppState.ThreadingType.PARALLEL);
        stateManager.attach((AppState)bulletAppState);
        bulletAppState.getPhysicsSpace().setAccuracy(0.016666668f);
        this.worldAppState = new WorldAppState();
        this.worldAppState.setLandType(WorldAppState.LandType.Grass);
        app.getStateManager().attach((AppState)this.worldAppState);
        this.worldAppState.setCalendar(2013, 1, 1, 12, 0, 0);
        Debug.enableDebugGrid((float)10.0f, (AssetManager)app.getAssetManager(), (Node)app.getRootNode());
        this.bodiesAppState = new BodiesAppState();
        stateManager.attach((AppState)this.bodiesAppState);
        this.bodiesAppState.createBody(BodiesAppState.BodyType.ElderLP, "Patient");
        this.bodiesAppState.runCommand((PHATCommand)new SetBodyInCoordenatesCommand("Patient", Vector3f.ZERO));
        this.bodiesAppState.runCommand((PHATCommand)new RandomWalkingCommand("Patient", true));
        this.bodiesAppState.runCommand((PHATCommand)new TremblingHandCommand("Patient", Boolean.valueOf(true), Boolean.valueOf(true)));
        TremblingHeadCommand thc = new TremblingHeadCommand("Patient", Boolean.valueOf(true));
        thc.setAngular(Float.valueOf(1.5707964f));
        this.bodiesAppState.runCommand((PHATCommand)thc);
        this.bodiesAppState.runCommand((PHATCommand)new SetSpeedDisplacemenetCommand("Patient", 0.5f));
        this.bodiesAppState.runCommand((PHATCommand)new SetStoopedBodyCommand("Patient", Boolean.valueOf(true)));
        SetCameraToBodyCommand camCommand = new SetCameraToBodyCommand("Patient");
        camCommand.setDistance(3.0f);
        camCommand.setFront(true);
        this.bodiesAppState.runCommand((PHATCommand)camCommand);
        this.devicesAppState = new DevicesAppState();
        stateManager.attach((AppState)this.devicesAppState);
        this.devicesAppState.runCommand((PHATDeviceCommand)new CreateSmartphoneCommand("Smartphone1"));
        this.devicesAppState.runCommand((PHATDeviceCommand)new SetDeviceOnPartOfBodyCommand("Patient", "Smartphone1", SetDeviceOnPartOfBodyCommand.PartOfBody.Chest));
        this.serverAppState = new ServerAppState();
        stateManager.attach((AppState)this.serverAppState);
        this.serverAppState.runCommand(new SetAndroidEmulatorCommand("Smartphone1", "Smartphone1", "emulator-5554"));
        this.serverAppState.runCommand(new StartActivityCommand("Smartphone1", "phat.android.apps", "BodyPositionMonitoring"));
        DisplayAVDScreenCommand displayCommand = new DisplayAVDScreenCommand("Smartphone1", "Smartphone1");
        displayCommand.setFrecuency(0.5f);
        this.serverAppState.runCommand(displayCommand);
        stateManager.attach((AppState)new AbstractAppState(){
            PHATApplication app;
            boolean standUp = false;
            boolean washingHands = false;
            boolean havingShower = false;
            float cont = 0.0f;
            boolean fall = false;
            float timeToFall = 10.0f;
            boolean init = false;

            public void initialize(AppStateManager asm, Application aplctn) {
                this.app = (PHATApplication)aplctn;
            }

            public void update(float f) {
                if (!this.init) {
                    AccelerometerControl ac = (AccelerometerControl)AccelerometerParkinsonTest.this.devicesAppState.getDevice("Smartphone1").getControl(AccelerometerControl.class);
                    ac.setMode(AccelerometerControl.AMode.GRAVITY_MODE);
                    XYAccelerationsChart chart = new XYAccelerationsChart("Chart - Acc.", "Smartphone1 accelerations", "m/s2", "x,y,z");
                    ac.add((SensorListener)chart);
                    chart.showWindow();
                    this.init = true;
                }
                this.cont += f;
                if (this.cont > this.timeToFall && this.cont < this.timeToFall + 1.0f && !this.fall) {
                    AccelerometerParkinsonTest.this.bodiesAppState.runCommand((PHATCommand)new FallDownCommand("Patient"));
                    this.fall = true;
                } else if (this.fall && this.cont > this.timeToFall + 6.0f) {
                    StandUpCommand standUp = new StandUpCommand("Patient");
                    AccelerometerParkinsonTest.this.bodiesAppState.runCommand((PHATCommand)standUp);
                    this.fall = false;
                    this.cont = 0.0f;
                }
            }
        });
    }
}

