/*
 * Decompiled with CFR 0.152.
 */
package phat.server.commands;

import com.jme3.app.Application;
import com.jme3.scene.Node;
import java.util.logging.Level;
import phat.commands.PHATCommand;
import phat.commands.PHATCommandListener;
import phat.devices.DevicesAppState;
import phat.mobile.adm.AndroidVirtualDevice;
import phat.server.ServerAppState;
import phat.server.commands.PHATServerCommand;

public class InstallApkCommand
extends PHATServerCommand {
    private String smartphoneId;
    private String apkFile;

    public InstallApkCommand(String smartphoneId, String apkFile) {
        this(smartphoneId, apkFile, null);
    }

    public InstallApkCommand(String smartphoneId, String apkFile, PHATCommandListener listener) {
        super(listener);
        this.smartphoneId = smartphoneId;
        this.apkFile = apkFile;
        logger.log(Level.INFO, "New Command: {0}", new Object[]{this});
    }

    public void runCommand(Application app) {
        AndroidVirtualDevice avd;
        DevicesAppState devicesAppState = (DevicesAppState)app.getStateManager().getState(DevicesAppState.class);
        ServerAppState serverAppState = (ServerAppState)app.getStateManager().getState(ServerAppState.class);
        Node smartphone = devicesAppState.getDevice(this.smartphoneId);
        if (smartphone != null && (avd = serverAppState.getAVD(this.smartphoneId)) != null) {
            avd.install(this.apkFile);
            this.setState(PHATCommand.State.Success);
            return;
        }
        this.setState(PHATCommand.State.Fail);
    }

    public void interruptCommand(Application app) {
        this.setState(PHATCommand.State.Interrupted);
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "(" + this.smartphoneId + ", " + this.apkFile + ")";
    }
}

