/*
 * Decompiled with CFR 0.152.
 */
package phat.server.doorSensor;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.logging.Level;
import java.util.logging.Logger;
import phat.client.sensor.presence.PHATDoorSensorData;
import phat.sensors.Sensor;
import phat.sensors.SensorData;
import phat.sensors.SensorListener;
import phat.sensors.door.DoorData;
import phat.sensors.door.PHATDoorSensor;
import phat.server.TCPSensorServer;
import phat.server.microphone.TCPAudioMicroServer;

public class TCPDoorSensorServer
implements SensorListener,
TCPSensorServer {
    protected ServerSocket serverSocket;
    protected ObjectOutputStream oos;
    private String ip;
    private int port;
    private Thread serverThread;
    private Socket socket;
    private boolean endServer = false;
    PHATDoorSensor doorSensor;
    PHATDoorSensorData dataBuff;

    public TCPDoorSensorServer(InetAddress ip, int port, PHATDoorSensor doorSensor) throws IOException {
        this.ip = ip.getHostAddress();
        this.port = port;
        this.doorSensor = doorSensor;
        this.serverSocket = new ServerSocket(port, 0, ip);
    }

    @Override
    public String getIp() {
        return this.ip;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public void start() {
        this.serverThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    while (!TCPDoorSensorServer.this.endServer) {
                        try {
                            Socket socket = TCPDoorSensorServer.this.serverSocket.accept();
                            System.out.println("Nuevo Cliente: " + socket);
                            TCPDoorSensorServer.this.upClient(socket);
                        }
                        catch (SocketException ex) {
                            if (TCPDoorSensorServer.this.endServer) continue;
                            Logger.getLogger(TCPAudioMicroServer.class.getName()).log(Level.SEVERE, null, ex);
                        }
                    }
                }
                catch (IOException ex) {
                    Logger.getLogger(TCPAudioMicroServer.class.getName()).log(Level.SEVERE, null, ex);
                    TCPDoorSensorServer.this.socket = null;
                    TCPDoorSensorServer.this.oos = null;
                }
            }
        });
        this.serverThread.start();
    }

    private synchronized void upClient(Socket socket) {
        this.socket = socket;
        this.dataBuff = new PHATDoorSensorData(0L, false);
        this.doorSensor.add((SensorListener)this);
        try {
            this.oos = new ObjectOutputStream(socket.getOutputStream());
        }
        catch (IOException ex) {
            Logger.getLogger(TCPAudioMicroServer.class.getName()).log(Level.SEVERE, null, ex);
            this.oos = null;
            this.socket = null;
        }
    }

    @Override
    public void stop() {
        this.doorSensor.remove((SensorListener)this);
        try {
            this.endServer = true;
            this.serverSocket.close();
            if (this.oos != null) {
                this.oos.close();
                this.oos = null;
            }
            if (this.socket != null) {
                this.socket.close();
                this.socket = null;
            }
        }
        catch (IOException e1) {
            Logger.getLogger(this.getClass().getSimpleName()).log(Level.SEVERE, null, e1);
        }
    }

    public void update(Sensor source, SensorData sd) {
        if (this.socket == null || this.oos == null) {
            return;
        }
        if (sd instanceof DoorData) {
            DoorData presenceData = (DoorData)sd;
            if (this.socket != null && this.socket.isConnected() && this.oos != null) {
                try {
                    this.dataBuff.setTimestamp(presenceData.getTimestamp());
                    this.dataBuff.setOpened(presenceData.isOpened());
                    this.oos.writeObject(this.dataBuff);
                    this.oos.flush();
                    this.oos.reset();
                }
                catch (IOException e1) {
                    Logger.getLogger(this.getClass().getSimpleName()).log(Level.SEVERE, null, e1);
                    this.socket = null;
                    this.oos = null;
                }
            }
        }
    }

    public void cleanUp() {
        this.stop();
    }
}

