/*
 * Decompiled with CFR 0.152.
 */
package phat.server.commands;

import com.jme3.app.Application;
import com.jme3.scene.Node;
import java.util.logging.Level;
import java.util.logging.Logger;
import phat.commands.PHATCommand;
import phat.commands.PHATCommandListener;
import phat.devices.DevicesAppState;
import phat.mobile.adm.AndroidVirtualDevice;
import phat.server.ServerAppState;
import phat.server.commands.PHATServerCommand;

public class PressOnScreen
extends PHATServerCommand {
    private String smartphoneId;
    private int x;
    private int y;
    private int duration = 0;
    TouchingThread thread;

    public PressOnScreen(String smartphoneId, int x, int y) {
        this(smartphoneId, x, y, 0, null);
    }

    public PressOnScreen(String smartphoneId, int x, int y, int duration) {
        this(smartphoneId, x, y, duration, null);
    }

    public PressOnScreen(String smartphoneId, int x, int y, PHATCommandListener listener) {
        this(smartphoneId, x, y, 0, listener);
    }

    public PressOnScreen(String smartphoneId, int x, int y, int duration, PHATCommandListener listener) {
        super(listener);
        this.smartphoneId = smartphoneId;
        this.x = x;
        this.y = y;
        this.duration = duration;
        logger.log(Level.INFO, "New Command: {0}", new Object[]{this});
    }

    public void runCommand(Application app) {
        this.thread = new TouchingThread(app, this);
        this.thread.start();
    }

    public void interruptCommand(Application app) {
        this.setState(PHATCommand.State.Interrupted);
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "(" + this.smartphoneId + ", " + this.x + ", " + this.y + ")";
    }

    class TouchingThread
    extends Thread {
        Application app;
        PressOnScreen pos;

        public TouchingThread(Application app, PressOnScreen pos) {
            this.app = app;
            this.pos = pos;
        }

        @Override
        public void run() {
            AndroidVirtualDevice avd;
            DevicesAppState devicesAppState = (DevicesAppState)this.app.getStateManager().getState(DevicesAppState.class);
            ServerAppState serverAppState = (ServerAppState)this.app.getStateManager().getState(ServerAppState.class);
            Node smartphone = devicesAppState.getDevice(PressOnScreen.this.smartphoneId);
            if (smartphone != null && (avd = serverAppState.getAVD(PressOnScreen.this.smartphoneId)) != null) {
                if (PressOnScreen.this.duration == 0) {
                    avd.tap(PressOnScreen.this.x, PressOnScreen.this.y);
                } else {
                    avd.touchDown(PressOnScreen.this.x, PressOnScreen.this.y);
                    try {
                        TouchingThread.sleep(PressOnScreen.this.duration);
                    }
                    catch (InterruptedException ex) {
                        Logger.getLogger(PressOnScreen.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    avd.touchUp(PressOnScreen.this.x, PressOnScreen.this.y);
                }
                this.pos.setState(PHATCommand.State.Success);
                return;
            }
            this.pos.setState(PHATCommand.State.Fail);
        }
    }
}

