/*
 * Decompiled with CFR 0.152.
 */
package phat.server;

import com.jme3.app.Application;
import com.jme3.app.SimpleApplication;
import com.jme3.app.state.AbstractAppState;
import com.jme3.app.state.AppStateManager;
import com.jme3.asset.AssetManager;
import com.jme3.audio.AudioRenderer;
import com.jme3.bullet.BulletAppState;
import com.jme3.renderer.Camera;
import com.jme3.renderer.RenderManager;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import phat.devices.smartphone.SmartPhoneFactory;
import phat.mobile.adm.AndroidVirtualDevice;
import phat.server.PHATServerManager;
import phat.server.commands.DisplayAVDScreenCommand;
import phat.server.commands.PHATServerCommand;
import phat.structures.houses.HouseAppState;
import phat.world.WorldAppState;

public class ServerAppState
extends AbstractAppState {
    SimpleApplication app;
    AssetManager assetManager;
    BulletAppState bulletAppState;
    PHATServerManager serverManager;
    HouseAppState houseAppState;
    WorldAppState worldAppState;
    Map<String, AndroidVirtualDevice> availableAVDs = new HashMap<String, AndroidVirtualDevice>();
    ConcurrentLinkedQueue<PHATServerCommand> runningCommands = new ConcurrentLinkedQueue();
    ConcurrentLinkedQueue<PHATServerCommand> pendingCommands = new ConcurrentLinkedQueue();

    public void initialize(AppStateManager stateManager, Application application) {
        System.out.println("Inititalize " + ((Object)((Object)this)).getClass().getSimpleName());
        super.initialize(stateManager, application);
        this.app = (SimpleApplication)application;
        this.assetManager = application.getAssetManager();
        this.worldAppState = (WorldAppState)this.app.getStateManager().getState(WorldAppState.class);
        this.houseAppState = (HouseAppState)this.app.getStateManager().getState(HouseAppState.class);
        this.bulletAppState = (BulletAppState)this.app.getStateManager().getState(BulletAppState.class);
        this.serverManager = new PHATServerManager();
        SmartPhoneFactory.init((BulletAppState)this.bulletAppState, (AssetManager)this.assetManager, (RenderManager)this.app.getRenderManager(), (Camera)this.app.getCamera(), (AudioRenderer)this.app.getAudioRenderer());
    }

    public void runCommand(PHATServerCommand command) {
        this.pendingCommands.add(command);
    }

    public void update(float tpf) {
        super.update(tpf);
        this.runningCommands.addAll(this.pendingCommands);
        this.pendingCommands.clear();
        for (PHATServerCommand bc : this.runningCommands) {
            bc.run((Application)this.app);
        }
        this.runningCommands.clear();
    }

    public void addAVD(String smartphoneId, AndroidVirtualDevice avd) {
        this.availableAVDs.put(smartphoneId, avd);
    }

    public PHATServerManager getServerManager() {
        return this.serverManager;
    }

    public AndroidVirtualDevice getAVD(String deviceId) {
        return this.availableAVDs.get(deviceId);
    }

    public void cleanup() {
        super.cleanup();
        Set<String> ids = this.availableAVDs.keySet();
        if (ids != null) {
            for (String id : ids) {
                AndroidVirtualDevice avd = this.availableAVDs.get(id);
                String avdId = avd.getAvdName();
                new DisplayAVDScreenCommand(id, avdId, false).run((Application)this.app);
                avd.pressBackPhysicalButton();
                avd.pressBackPhysicalButton();
            }
        }
        if (ids != null && !ids.isEmpty()) {
            AndroidVirtualDevice.shutdown();
        }
        if (this.serverManager != null) {
            System.out.println("ServerManager Stopped!!");
            this.serverManager.stop();
        }
    }
}

