/*
 * Decompiled with CFR 0.152.
 */
package phat.server.accelerometer;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.logging.Level;
import java.util.logging.Logger;
import phat.sensors.Sensor;
import phat.sensors.SensorData;
import phat.sensors.SensorListener;
import phat.sensors.accelerometer.AccelerationData;
import phat.sensors.accelerometer.AccelerometerControl;
import phat.server.TCPSensorServer;
import phat.server.microphone.TCPAudioMicroServer;
import sim.android.hardware.service.SimSensorEvent;

public class TCPAccelerometerServer
implements SensorListener,
TCPSensorServer {
    protected ServerSocket serverSocket;
    protected ObjectOutputStream oos;
    private String ip;
    private int port;
    private Thread serverThread;
    private Socket socket;
    private boolean endServer = false;
    AccelerometerControl accSensor;

    public TCPAccelerometerServer(InetAddress ip, int port, AccelerometerControl accSensor) throws IOException {
        this.ip = ip.getHostAddress();
        this.port = port;
        this.accSensor = accSensor;
        this.serverSocket = new ServerSocket(port, 0, ip);
    }

    @Override
    public String getIp() {
        return this.ip;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public void start() {
        this.serverThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    while (!TCPAccelerometerServer.this.endServer) {
                        Socket socket = TCPAccelerometerServer.this.serverSocket.accept();
                        System.out.println("Nuevo Cliente: " + socket);
                        TCPAccelerometerServer.this.upClient(socket);
                    }
                }
                catch (IOException ex) {
                    Logger.getLogger(TCPAudioMicroServer.class.getName()).log(Level.SEVERE, null, ex);
                    TCPAccelerometerServer.this.socket = null;
                    TCPAccelerometerServer.this.oos = null;
                }
            }
        });
        this.serverThread.start();
    }

    private synchronized void upClient(Socket socket) {
        this.socket = socket;
        this.accSensor.add((SensorListener)this);
        try {
            this.oos = new ObjectOutputStream(socket.getOutputStream());
        }
        catch (IOException ex) {
            Logger.getLogger(TCPAudioMicroServer.class.getName()).log(Level.SEVERE, null, ex);
            this.oos = null;
            this.socket = null;
        }
    }

    @Override
    public void stop() {
        this.accSensor.remove((SensorListener)this);
        try {
            this.endServer = true;
            this.serverThread.interrupt();
            if (this.oos != null) {
                this.oos.close();
                this.oos = null;
            }
            if (this.socket != null) {
                this.socket.close();
                this.socket = null;
            }
        }
        catch (IOException e1) {
            Logger.getLogger(this.getClass().getSimpleName()).log(Level.SEVERE, null, e1);
        }
    }

    public void update(Sensor source, SensorData sd) {
        if (this.socket == null || this.oos == null) {
            return;
        }
        if (sd instanceof AccelerationData) {
            AccelerationData accData = (AccelerationData)sd;
            if (this.socket != null && this.socket.isConnected() && this.oos != null) {
                try {
                    float[] data = new float[]{accData.getX(), accData.getY(), accData.getZ()};
                    SimSensorEvent sse = new SimSensorEvent(1, data, 0L, Math.round(1.0f / accData.getInterval()));
                    this.oos.writeObject(sse);
                    this.oos.flush();
                    this.oos.reset();
                }
                catch (IOException e1) {
                    Logger.getLogger(this.getClass().getSimpleName()).log(Level.SEVERE, null, e1);
                    this.socket = null;
                    this.oos = null;
                }
            }
        }
    }

    public void cleanUp() {
        this.stop();
    }
}

