/*
 * Decompiled with CFR 0.152.
 */
package phat.server.microphone;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.logging.Level;
import java.util.logging.Logger;
import phat.sensors.Sensor;
import phat.sensors.SensorData;
import phat.sensors.SensorListener;
import phat.sensors.microphone.MicrophoneData;
import phat.server.TCPSensorServer;
import sim.android.media.service.AudioStreamDataPacket;

public class TCPAudioMicroServer
implements SensorListener,
TCPSensorServer {
    protected ServerSocket serverSocket;
    protected ObjectOutputStream oos;
    private String ip;
    private int port;
    private Thread serverThread;
    private Socket socket;
    private boolean endServer = false;

    public TCPAudioMicroServer(InetAddress ip, int port) throws IOException {
        this.ip = ip.getHostAddress();
        this.port = port;
        this.serverSocket = new ServerSocket(port, 0, ip);
    }

    @Override
    public String getIp() {
        return this.ip;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public void start() {
        this.serverThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    while (!TCPAudioMicroServer.this.endServer) {
                        Socket socket = TCPAudioMicroServer.this.serverSocket.accept();
                        System.out.println("Nuevo Cliente: " + socket);
                        TCPAudioMicroServer.this.upClient(socket);
                    }
                }
                catch (IOException ex) {
                    Logger.getLogger(TCPAudioMicroServer.class.getName()).log(Level.SEVERE, null, ex);
                    TCPAudioMicroServer.this.socket = null;
                    TCPAudioMicroServer.this.oos = null;
                }
            }
        });
        this.serverThread.start();
    }

    private synchronized void upClient(Socket socket) {
        this.socket = socket;
        try {
            this.oos = new ObjectOutputStream(socket.getOutputStream());
        }
        catch (IOException ex) {
            Logger.getLogger(TCPAudioMicroServer.class.getName()).log(Level.SEVERE, null, ex);
            this.oos = null;
            this.socket = null;
        }
    }

    public boolean send(byte[] buffer, int offset, int numSamples, int numReadings) {
        if (this.socket != null && this.socket.isConnected() && this.oos != null) {
            try {
                int totalSize = numSamples * numReadings;
                byte[] data = new byte[totalSize];
                System.arraycopy(buffer, offset, data, 0, totalSize);
                AudioStreamDataPacket asdp = new AudioStreamDataPacket(data, numSamples, numReadings);
                this.oos.writeObject(asdp);
                this.oos.flush();
                this.oos.reset();
            }
            catch (IOException e1) {
                Logger.getLogger(this.getClass().getSimpleName()).log(Level.SEVERE, null, e1);
                this.socket = null;
                this.oos = null;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public void stop() {
        try {
            this.endServer = true;
            this.serverThread.interrupt();
            if (this.oos != null) {
                this.oos.close();
                this.oos = null;
            }
            if (this.socket != null) {
                this.socket.close();
                this.socket = null;
            }
        }
        catch (IOException e1) {
            Logger.getLogger(this.getClass().getSimpleName()).log(Level.SEVERE, null, e1);
        }
    }

    public void update(Sensor source, SensorData sd) {
        if (this.socket == null || this.oos == null) {
            return;
        }
        if (sd instanceof MicrophoneData) {
            MicrophoneData microphoneData = (MicrophoneData)sd;
            if (this.socket != null && this.socket.isConnected() && this.oos != null) {
                try {
                    int totalSize = microphoneData.getData().length;
                    int numSamples = microphoneData.getAudioFormat().getSampleSizeInBits();
                    byte[] data = new byte[totalSize];
                    System.arraycopy(microphoneData.getData(), 0, data, 0, totalSize);
                    AudioStreamDataPacket asdp = new AudioStreamDataPacket(data, numSamples, totalSize / numSamples);
                    this.oos.writeObject(asdp);
                    this.oos.flush();
                    this.oos.reset();
                }
                catch (IOException e1) {
                    Logger.getLogger(this.getClass().getSimpleName()).log(Level.SEVERE, null, e1);
                    this.socket = null;
                    this.oos = null;
                    return;
                }
            }
        }
    }

    public void cleanUp() {
        this.stop();
    }
}

