/*
 * Decompiled with CFR 0.152.
 */
package phat.server;

import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import phat.mobile.servicemanager.server.ServiceManagerServer;
import phat.mobile.servicemanager.services.Service;
import phat.mobile.servicemanager.services.ServiceImpl;
import phat.sensors.SensorListener;
import phat.sensors.accelerometer.AccelerometerControl;
import phat.sensors.camera.CameraSensor;
import phat.sensors.microphone.MicrophoneControl;
import phat.server.TCPSensorServer;
import phat.server.accelerometer.TCPAccelerometerServer;
import phat.server.camera.TCPCameraSensorServer;
import phat.server.microphone.TCPAudioMicroServer;

public class PHATServerManager {
    InetAddress inetAddress = this.getAddress();
    Map<String, List<TCPSensorServer>> tcpSensorServers = new HashMap<String, List<TCPSensorServer>>();

    public TCPAudioMicroServer createAndStartAudioMicroServer(String id, MicrophoneControl mc) {
        TCPAudioMicroServer ams = null;
        int port = ServiceManagerServer.getInstance().getNextPort();
        try {
            System.out.println("IP:PORT -> " + this.inetAddress + ":" + port);
            ams = new TCPAudioMicroServer(this.inetAddress, port);
        }
        catch (IOException ex) {
            Logger.getLogger(PHATServerManager.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
        mc.add((SensorListener)ams);
        this.registerService(id, ams, "microphone");
        ams.start();
        this.add(id, ams);
        return ams;
    }

    public TCPCameraSensorServer createAndStartCameraServer(String id, CameraSensor cameraSensor) {
        TCPCameraSensorServer ams = null;
        int port = ServiceManagerServer.getInstance().getNextPort();
        try {
            System.out.println("IP:PORT -> " + this.inetAddress + ":" + port);
            ams = new TCPCameraSensorServer(this.inetAddress, port);
        }
        catch (IOException ex) {
            Logger.getLogger(PHATServerManager.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
        cameraSensor.add((SensorListener)ams);
        this.registerService(id, ams, "camera");
        ams.start();
        this.add(id, ams);
        return ams;
    }

    public TCPAccelerometerServer createAndStartAccelerometerServer(String id, AccelerometerControl accSensor) {
        TCPAccelerometerServer ams = null;
        int port = ServiceManagerServer.getInstance().getNextPort();
        try {
            System.out.println("IP:PORT -> " + this.inetAddress + ":" + port);
            ams = new TCPAccelerometerServer(this.inetAddress, port);
        }
        catch (IOException ex) {
            Logger.getLogger(PHATServerManager.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
        accSensor.add((SensorListener)ams);
        this.registerService(id, ams, "accelerometer");
        ams.start();
        this.add(id, ams);
        return ams;
    }

    public void stop() {
        for (List<TCPSensorServer> list : this.tcpSensorServers.values()) {
            for (TCPSensorServer server : list) {
                server.stop();
            }
        }
        ServiceManagerServer.getInstance().stop();
    }

    private void add(String id, TCPSensorServer server) {
        List<TCPSensorServer> list = this.tcpSensorServers.get(id);
        if (list == null) {
            list = new ArrayList<TCPSensorServer>();
            this.tcpSensorServers.put(id, list);
        }
        list.add(server);
    }

    private void registerService(String serviceSetId, TCPSensorServer server, String type) {
        ServiceImpl service = new ServiceImpl(type, server.getIp(), server.getPort());
        System.out.println("New Service: " + service);
        ServiceManagerServer sms = ServiceManagerServer.getInstance();
        sms.getServiceManager().registerService(serviceSetId, (Service)service);
    }

    public String getIP() {
        return this.inetAddress.getHostAddress();
    }

    public int getPort() {
        return 65056;
    }

    private InetAddress getAddress() {
        try {
            Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
            while (e.hasMoreElements()) {
                NetworkInterface ni = e.nextElement();
                System.out.println("NetworkInterface = " + ni.getName());
                if (!ni.getName().contains("eth") && !ni.getName().contains("wlan")) continue;
                Enumeration<InetAddress> ee = ni.getInetAddresses();
                while (ee.hasMoreElements()) {
                    InetAddress ip = ee.nextElement();
                    if (!(ip instanceof Inet4Address) || ip.getAddress() == null) continue;
                    return ip;
                }
            }
            NetworkInterface lo = NetworkInterface.getByName("lo");
            if (lo != null) {
                Enumeration<InetAddress> ee = lo.getInetAddresses();
                while (ee.hasMoreElements()) {
                    InetAddress ip = ee.nextElement();
                    if (!(ip instanceof Inet4Address) || ip.getAddress() == null) continue;
                    return ip;
                }
            }
        }
        catch (Exception e) {
            System.err.println("Error");
        }
        return null;
    }
}

