/*
 * Decompiled with CFR 0.152.
 */
package phat.util;

import com.jme3.bullet.BulletAppState;
import com.jme3.bullet.control.PhysicsControl;
import com.jme3.bullet.control.RigidBodyControl;
import com.jme3.scene.SceneGraphVisitor;
import com.jme3.scene.Spatial;

public class PhysicsUtils {
    public static void setHighPhysicsPrecision(Spatial spatial) {
        float linear = 1.0E-4f;
        float angular = 1.0E-4f;
        float threshold = 1.0E-4f;
        float radius = 1.0f;
        SceneGraphVisitor visitor = new SceneGraphVisitor(){

            public void visit(Spatial spat) {
                RigidBodyControl rbc = (RigidBodyControl)spat.getControl(RigidBodyControl.class);
                if (rbc != null) {
                    rbc.setSleepingThresholds(1.0E-4f, 1.0E-4f);
                    rbc.setCcdMotionThreshold(1.0E-4f);
                    rbc.setCcdSweptSphereRadius(1.0f);
                }
            }
        };
        spatial.depthFirstTraversal(visitor);
    }

    public static void addAllPhysicsControls(Spatial spatial, BulletAppState bulletAppState) {
        for (int i = 0; i < spatial.getNumControls(); ++i) {
            if (!(spatial.getControl(i) instanceof PhysicsControl)) continue;
            bulletAppState.getPhysicsSpace().add((Object)spatial.getControl(i));
        }
    }

    public static void updateLocationAndRotation(Spatial spatial) {
        SceneGraphVisitor visitor = new SceneGraphVisitor(){

            public void visit(Spatial spat) {
                RigidBodyControl rbc = (RigidBodyControl)spat.getControl(RigidBodyControl.class);
                if (rbc != null) {
                    rbc.setPhysicsLocation(spat.getWorldTranslation());
                    rbc.setPhysicsRotation(spat.getWorldRotation());
                }
            }
        };
        spatial.depthFirstTraversal(visitor);
    }
}

