/*
 * Decompiled with CFR 0.152.
 */
package phat.util;

import java.io.File;
import java.io.FileFilter;

public class PHATUtils {
    public static void removeFile(String filePath) {
        File file = new File(filePath);
        if (file.exists()) {
            file.delete();
        }
    }

    public static void removeFileWithExtension(String path, final String extension) {
        File[] files;
        for (File file : files = new File(path).listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (file.isFile()) {
                    return file.getName().endsWith('.' + extension);
                }
                return false;
            }
        })) {
            file.delete();
        }
    }

    public static void removeNativeFiles() {
        if (PHATUtils.isWindows()) {
            PHATUtils.removeFileWithExtension(".", "dll");
        } else {
            PHATUtils.removeFileWithExtension(".", "so");
        }
    }

    public static boolean isWindows() {
        String so = System.getProperty("os.name");
        return so.contains("Windows");
    }

    public static void checkAndCreatePath(String path) {
        File folder = new File(path);
        if (!folder.exists()) {
            folder.mkdirs();
        }
    }

    public static boolean isMultiListener(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equals("-ml")) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(String[] args, String arg) {
        for (String a : args) {
            if (!a.equals(arg)) continue;
            return true;
        }
        return false;
    }
}

