/*
 * Decompiled with CFR 0.152.
 */
package phat.controls;

import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.math.Quaternion;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.ViewPort;
import com.jme3.scene.Spatial;
import com.jme3.scene.control.AbstractControl;
import com.jme3.scene.control.Control;
import java.io.IOException;

public class FridgeDoorControl
extends AbstractControl {
    STATE state = STATE.CLOSE;
    boolean stateChanged = false;
    float angularSpeed = 0.7853982f;
    float openingAngle = 1.0995574f;
    float[] angles = new float[3];

    protected void controlUpdate(float tpf) {
        if (this.stateChanged) {
            this.spatial.getLocalRotation().toAngles(this.angles);
            float rot = tpf * this.angularSpeed;
            if (this.state.equals((Object)STATE.CLOSE)) {
                this.angles[2] = this.angles[2] - rot;
                if (this.angles[2] < 0.0f) {
                    this.angles[2] = 0.0f;
                    this.stateChanged = false;
                }
                this.spatial.setLocalRotation(new Quaternion(this.angles));
            } else if (this.state.equals((Object)STATE.OPEN)) {
                this.angles[2] = this.angles[2] + rot;
                if (this.angles[2] > this.openingAngle) {
                    this.angles[2] = this.openingAngle;
                    this.stateChanged = false;
                }
                this.spatial.setLocalRotation(new Quaternion(this.angles));
            }
        }
    }

    protected void controlRender(RenderManager rm, ViewPort vp) {
    }

    public Control cloneForSpatial(Spatial spatial) {
        FridgeDoorControl control = new FridgeDoorControl();
        control.setSpatial(spatial);
        control.setAngularSpeed(this.angularSpeed);
        control.setOpeningAngle(this.openingAngle);
        return control;
    }

    public STATE getState() {
        return this.state;
    }

    public void setState(STATE state) {
        if (state.compareTo(this.state) != 0) {
            this.state = state;
            this.stateChanged = true;
        }
    }

    public float getAngularSpeed() {
        return this.angularSpeed;
    }

    public void setAngularSpeed(float angularSpeed) {
        this.angularSpeed = angularSpeed;
    }

    public float getOpeningAngle() {
        return this.openingAngle;
    }

    public void setOpeningAngle(float openingAngle) {
        this.openingAngle = openingAngle;
    }

    public void read(JmeImporter im) throws IOException {
        super.read(im);
        InputCapsule ic = im.getCapsule((Savable)this);
        this.state = (STATE)ic.readEnum("state", STATE.class, (Enum)STATE.CLOSE);
        this.angularSpeed = ic.readFloat("angularSpeed", 1.0995574f);
        this.openingAngle = ic.readFloat("openingAngle", 1.0995574f);
    }

    public void write(JmeExporter ex) throws IOException {
        super.write(ex);
        OutputCapsule oc = ex.getCapsule((Savable)this);
        oc.write((Enum)this.state, "state", (Enum)STATE.CLOSE);
        oc.write(this.angularSpeed, "angularSpeed", 0.7853982f);
        oc.write(this.openingAngle, "openingAngle", 1.0995574f);
    }

    public static enum STATE {
        OPEN,
        CLOSE;

    }
}

