/*
 * Decompiled with CFR 0.152.
 */
package phat.commands;

import com.jme3.app.Application;
import com.jme3.font.BitmapText;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector3f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.control.Control;
import java.util.logging.Level;
import phat.commands.PHATCommand;
import phat.commands.PHATCommandListener;
import phat.scene.control.PHATKeepObjectAtOffset;
import phat.util.SpatialFactory;
import phat.util.SpatialUtils;

public class ShowLabelOfObjectById
extends PHATCommand {
    Node debugNode;
    private String objectId;
    private String debugId;
    private Boolean show;
    private ColorRGBA colour = ColorRGBA.Black;
    private float scale = 0.2f;
    private Vector3f offset = new Vector3f(0.0f, 0.1f, 0.0f);

    public ShowLabelOfObjectById(String objectId, Boolean show, PHATCommandListener listener) {
        super(listener);
        this.objectId = objectId;
        this.show = show;
        logger.log(Level.INFO, "New Command: {0}", new Object[]{this});
    }

    public ShowLabelOfObjectById(String bodyId, Boolean show) {
        this(bodyId, show, null);
    }

    @Override
    public void runCommand(Application app) {
        Spatial object = SpatialUtils.getSpatialById((Spatial)SpatialFactory.getRootNode(), this.objectId);
        if (object != null) {
            this.debugId = this.objectId + "BitmapText";
            Node rootNode = SpatialFactory.getRootNode();
            this.debugNode = (Node)rootNode.getChild("DebugNode");
            if (this.debugNode == null) {
                this.debugNode = new Node("DebugNode");
                rootNode.attachChild((Spatial)this.debugNode);
            }
            if (this.show.booleanValue()) {
                this.attachName(object);
            } else {
                this.dettachName(object);
            }
        } else {
            this.setState(PHATCommand.State.Fail);
        }
        this.setState(PHATCommand.State.Success);
    }

    private Node attachName(Node target, Spatial source, String name) {
        Node textNode = (Node)target.getChild(name);
        if (textNode == null) {
            textNode = new Node(name);
            PHATKeepObjectAtOffset offsetControl = new PHATKeepObjectAtOffset(source);
            offsetControl.setOffset(this.offset);
            textNode.addControl((Control)offsetControl);
            BitmapText text = SpatialFactory.attachAName(textNode, name);
            text.setColor(this.colour);
            text.setLocalScale(this.scale);
            Geometry cube = SpatialFactory.createCube(new Vector3f(0.02f, 0.02f, 0.02f), ColorRGBA.Red);
            cube.setLocalTranslation(this.offset.negate().addLocal(0.0f, 0.01f, 0.0f));
            textNode.attachChild((Spatial)cube);
            target.attachChild((Spatial)textNode);
        }
        return textNode;
    }

    private void attachName(Spatial s) {
        Node p;
        Spatial places;
        Node result = this.attachName(this.debugNode, s, this.objectId);
        if (s instanceof Node && (places = ((Node)s).getChild("Places")) != null && (p = (Node)places).getChildren() != null) {
            for (Spatial pos : p.getChildren()) {
                this.attachName(this.debugNode, pos, this.objectId + ":" + pos.getName());
            }
        }
    }

    private void calculateOffset(Spatial s) {
        Vector3f targetPosition = SpatialUtils.getCenterBoinding(s);
        Vector3f max = SpatialUtils.getMaxBounding(s);
        System.out.println(s.getName() + ":" + targetPosition + ":" + max);
        targetPosition.setY(max.y);
        this.offset.addLocal(targetPosition.subtract(s.getWorldTranslation()));
        System.out.println("Offset -> " + this.offset);
    }

    private void dettachName(Spatial s) {
        Spatial child = this.debugNode.getChild(this.debugId);
        if (child != null) {
            child.removeFromParent();
        }
    }

    @Override
    public void interruptCommand(Application app) {
        this.show = false;
        this.runCommand(app);
    }

    public Vector3f getOffset() {
        return this.offset;
    }

    public ShowLabelOfObjectById setOffset(Vector3f offset) {
        this.offset.set(offset);
        return this;
    }

    public ColorRGBA getColour() {
        return this.colour;
    }

    public ShowLabelOfObjectById setColour(ColorRGBA colour) {
        this.colour = colour;
        return this;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.objectId + ",show=" + this.show + ")";
    }
}

