/*
 * Decompiled with CFR 0.152.
 */
package phat.commands;

import com.jme3.app.Application;
import java.util.logging.Level;
import java.util.logging.Logger;
import phat.commands.PHATCommandListener;

public abstract class PHATCommand {
    protected static final Logger logger = Logger.getLogger(PHATCommand.class.getName());
    PHATCommandListener listener;
    Function function = Function.Run;
    State state = State.Waiting;

    public PHATCommand(PHATCommandListener listener) {
        this.listener = listener;
    }

    public void run(Application app) {
        if (this.function.equals((Object)Function.Run) && this.state.equals((Object)State.Waiting)) {
            this.setState(State.Running);
            logger.log(Level.INFO, "Running Command: {0}", new Object[]{this});
            this.runCommand(app);
        } else if (this.function.equals((Object)Function.Interrupt) && this.state.equals((Object)State.Running)) {
            logger.log(Level.INFO, "Interrupting Command: {0}", new Object[]{this});
            this.interruptCommand(app);
        }
    }

    public abstract void runCommand(Application var1);

    public abstract void interruptCommand(Application var1);

    public State getState() {
        return this.state;
    }

    protected void setState(State state) {
        this.state = state;
        logger.log(Level.INFO, "Command {1} Finished: {0}", new Object[]{state.name(), this.toString()});
        if (this.listener != null) {
            this.listener.commandStateChanged(this);
        }
    }

    public Function getFunction() {
        return this.function;
    }

    public void setFunction(Function function) {
        this.function = function;
    }

    public static enum State {
        Waiting,
        Running,
        Interrupted,
        Success,
        Fail;

    }

    public static enum Function {
        Run,
        Interrupt;

    }
}

