/*
 * Decompiled with CFR 0.152.
 */
package phat.app;

import com.jme3.app.SimpleApplication;
import com.jme3.app.state.AppState;
import com.jme3.audio.AudioContext;
import com.jme3.audio.AudioRenderer;
import phat.app.PHATFinalizeAppListener;
import phat.app.PHATInitAppListener;

public class PHATApplication
extends SimpleApplication {
    PHATInitAppListener initializer;
    PHATFinalizeAppListener finalizer;
    private boolean initialized = false;

    public PHATApplication(PHATInitAppListener initializer, AppState ... states) {
        super(states);
        this.initializer = initializer;
        this.setShowSettings(false);
        this.setPauseOnLostFocus(false);
    }

    public PHATApplication(PHATInitAppListener initializer) {
        this.initializer = initializer;
        this.setShowSettings(false);
        this.setPauseOnLostFocus(false);
    }

    public void simpleInitApp() {
        this.initializer.init(this);
        this.initialized = true;
        this.flyCam.setDragToRotate(true);
    }

    public void update() {
        this.simpleApplicationUpdate();
        if (this.speed == 0.0f) {
            this.timer.update();
            float tpf = this.timer.getTimePerFrame();
            if (this.inputEnabled) {
                this.inputManager.update(tpf);
            }
            this.guiNode.updateLogicalState(tpf);
            this.guiNode.updateGeometricState();
            this.stateManager.render(this.renderManager);
            this.renderManager.render(tpf, this.context.isRenderable());
            this.simpleRender(this.renderManager);
            this.stateManager.postRender();
        }
    }

    private void applicationUpdate() {
        AudioContext.setAudioRenderer((AudioRenderer)this.audioRenderer);
        this.runQueuedTasks();
        if (this.speed == 0.0f || this.paused) {
            return;
        }
        this.timer.update();
        if (this.inputEnabled) {
            this.inputManager.update(this.timer.getTimePerFrame());
        }
        if (this.audioRenderer != null) {
            this.audioRenderer.update(this.timer.getTimePerFrame());
        }
    }

    private void simpleApplicationUpdate() {
        this.applicationUpdate();
        if (this.speed == 0.0f || this.paused) {
            return;
        }
        float tpf = this.timer.getTimePerFrame() * this.speed;
        this.stateManager.update(tpf);
        this.simpleUpdate(tpf);
        this.rootNode.updateLogicalState(tpf);
        this.guiNode.updateLogicalState(tpf);
        this.rootNode.updateGeometricState();
        this.guiNode.updateGeometricState();
        this.stateManager.render(this.renderManager);
        this.renderManager.render(tpf, this.context.isRenderable());
        this.simpleRender(this.renderManager);
        this.stateManager.postRender();
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void setFinalizer(PHATFinalizeAppListener finalizer) {
        this.finalizer = finalizer;
    }

    public void finalize() throws Throwable {
        super.finalize();
        if (this.finalizer != null) {
            this.finalizer.finalize(this);
        }
    }

    public float getSimSpeed() {
        return this.speed;
    }

    public void setSimSpeed(float speed) {
        this.speed = speed;
    }
}

