/*
 * Decompiled with CFR 0.152.
 */
package phat.util.video;

import com.jme3.post.SceneProcessor;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.Renderer;
import com.jme3.renderer.ViewPort;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.texture.FrameBuffer;
import com.jme3.util.BufferUtils;
import java.io.File;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import phat.util.video.JavaCVWriter;
import phat.util.video.VideoSequenceWriter;

public class VideoRenderScreenProcessor
implements SceneProcessor {
    private RenderManager renderManager;
    private ViewPort viewPort;
    private int width;
    private int height;
    private VideoSequenceWriter videoWriter;
    private File output;
    private boolean initialized;
    private AtomicBoolean writing;
    private FrameBuffer originalFB;

    public VideoRenderScreenProcessor(File output) {
        this.output = output;
        this.initialized = false;
    }

    public void initialize(RenderManager rm, ViewPort vp) {
        this.renderManager = rm;
        this.width = vp.getCamera().getWidth();
        this.height = vp.getCamera().getHeight();
        this.viewPort = vp;
        this.writing = new AtomicBoolean(true);
        this.videoWriter = new JavaCVWriter(this.width, this.height);
        this.videoWriter.start(this.output);
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                VideoRenderScreenProcessor.this.cleanup();
            }
        }));
        this.reshape(vp, vp.getCamera().getWidth(), vp.getCamera().getHeight());
        this.initialized = true;
    }

    public void reshape(ViewPort vp, int w, int h) {
        this.width = w;
        this.height = h;
        this.videoWriter.setWidth(this.width);
        this.videoWriter.setHeight(this.height);
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void preFrame(float tpf) {
    }

    public void postQueue(RenderQueue rq) {
    }

    public void postFrame(FrameBuffer out) {
        if (!this.initialized) {
            return;
        }
        if (!this.isLastProcessor()) {
            return;
        }
        Renderer renderer = this.renderManager.getRenderer();
        ByteBuffer cpuBuff = VideoRenderScreenProcessor.getSharedBuffer(this.width * this.height * 4);
        renderer.readFrameBuffer(out, cpuBuff);
        try {
            this.videoWriter.writePicture(cpuBuff);
        }
        catch (RuntimeException e) {
            System.err.println("Problematic viewPort: " + this.viewPort.getName());
            throw e;
        }
    }

    public boolean isLastProcessor() {
        List processors = this.viewPort.getProcessors();
        return processors.get(processors.size() - 1) == this;
    }

    public void cleanup() {
        if (this.writing.getAndSet(false) && this.videoWriter != null) {
            this.videoWriter.stop();
        }
    }

    private static ByteBuffer getSharedBuffer(int size) {
        SharedCPUByteBuffer current = (SharedCPUByteBuffer)SharedCPUByteBuffer.cpuByteBufferTL.get();
        if (current.byteBuffer != null) {
            current.byteBuffer.clear();
        }
        current.byteBuffer = BufferUtils.ensureLargeEnough((ByteBuffer)current.byteBuffer, (int)size);
        return current.byteBuffer;
    }

    public ViewPort getViewPort() {
        return this.viewPort;
    }

    public FrameBuffer getOriginalFB() {
        return this.originalFB;
    }

    private static class SharedCPUByteBuffer {
        private ByteBuffer byteBuffer;
        private static ThreadLocal<SharedCPUByteBuffer> cpuByteBufferTL = ThreadLocal.withInitial(new Supplier<SharedCPUByteBuffer>(){

            @Override
            public SharedCPUByteBuffer get() {
                return new SharedCPUByteBuffer();
            }
        });

        private SharedCPUByteBuffer() {
        }
    }
}

