/*
 * Decompiled with CFR 0.152.
 */
package phat.util.video;

import com.jme3.app.Application;
import com.jme3.app.state.AbstractAppState;
import com.jme3.app.state.AppStateManager;
import com.jme3.post.SceneProcessor;
import com.jme3.renderer.ViewPort;
import com.jme3.texture.FrameBuffer;
import com.jme3.util.SafeArrayList;
import java.io.File;
import java.util.List;
import phat.util.video.VideoRenderScreenProcessor;

public class VideoRenderAppState
extends AbstractAppState {
    private List<VideoRenderScreenProcessor> processors = new SafeArrayList(VideoRenderScreenProcessor.class);

    public void initialize(AppStateManager stateManager, Application app) {
        super.initialize(stateManager, app);
    }

    public void recordViewPort(ViewPort vp, File output) {
        this.recordViewPort(vp, output, vp.getOutputFrameBuffer());
    }

    public void stopRecording(ViewPort vp) {
        VideoRenderScreenProcessor toRemove = null;
        for (VideoRenderScreenProcessor p : this.processors) {
            if (p.getViewPort() != vp) continue;
            toRemove = p;
            break;
        }
        if (toRemove != null) {
            this.processors.remove(toRemove);
            vp.removeProcessor((SceneProcessor)toRemove);
        }
    }

    public void recordViewPort(ViewPort vp, File output, FrameBuffer ofb) {
        VideoRenderScreenProcessor processor = new VideoRenderScreenProcessor(output);
        vp.addProcessor((SceneProcessor)processor);
        this.processors.add(processor);
    }

    public void update(float tpf) {
        super.update(tpf);
        for (VideoRenderScreenProcessor osp : this.processors) {
            if (!osp.isInitialized()) continue;
            ViewPort vp = osp.getViewPort();
            this.ensureProcessorIsLast(vp);
        }
    }

    protected void ensureProcessorIsLast(ViewPort vp) {
        List processors = vp.getProcessors();
        int processorIndex = -1;
        for (int i = 0; i < processors.size(); ++i) {
            SceneProcessor processor = (SceneProcessor)processors.get(i);
            if (!(processor instanceof VideoRenderScreenProcessor)) continue;
            if (processorIndex != -1) {
                throw new IllegalStateException("ViewPort cannot have two processors of type " + VideoRenderScreenProcessor.class.getName());
            }
            processorIndex = i;
        }
        if (processorIndex == -1) {
            throw new IllegalStateException("Viewport does not have any screenProcessor of type " + VideoRenderScreenProcessor.class.getName() + ". Was it removed elsewhere?");
        }
        if (processorIndex > 0) {
            SceneProcessor recorder = (SceneProcessor)processors.remove(processorIndex);
            processors.add(recorder);
        }
    }

    public void cleanup() {
        super.cleanup();
        for (VideoRenderScreenProcessor p : this.processors) {
            p.cleanup();
        }
    }

    public void postRender() {
        super.postRender();
    }
}

