/*
 * Decompiled with CFR 0.152.
 */
package phat.util.video;

import com.jme3.app.Application;
import com.jme3.app.state.AppState;
import java.io.File;
import java.util.logging.Logger;
import phat.commands.PHATCommand;
import phat.util.video.VideoRenderAppState;

public class RecordVideoCommand
extends PHATCommand {
    private final File output;

    public RecordVideoCommand(File output) {
        super(null);
        this.output = output;
    }

    @Override
    public void runCommand(Application app) {
        Logger.getLogger(this.getClass().getName()).info("Starting video recording");
        VideoRenderAppState videoAppState = (VideoRenderAppState)app.getStateManager().getState(VideoRenderAppState.class);
        if (videoAppState == null) {
            videoAppState = new VideoRenderAppState();
            app.getStateManager().attach((AppState)videoAppState);
        }
        videoAppState.recordViewPort(app.getGuiViewPort(), this.output);
        this.setState(PHATCommand.State.Success);
    }

    @Override
    public void interruptCommand(Application app) {
        Logger.getLogger(this.getClass().getName()).info("Video recording stopped");
        VideoRenderAppState videoAppState = (VideoRenderAppState)app.getStateManager().getState(VideoRenderAppState.class);
        if (videoAppState != null) {
            app.getStateManager().detach((AppState)videoAppState);
        }
    }
}

