/*
 * Decompiled with CFR 0.152.
 */
package phat.util.video;

import java.io.File;
import java.nio.ByteBuffer;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Logger;
import org.bytedeco.javacv.Frame;
import org.bytedeco.javacv.FrameRecorder;
import phat.util.video.VideoSequenceWriter;

public class JavaCVWriter
implements VideoSequenceWriter {
    private FrameRecorder recorder;
    private int width;
    private int height;
    private ExecutorService executor;
    private double framerate = 25.0;
    private BlockingQueue<Frame> toWrite = new ArrayBlockingQueue<Frame>(512);
    private Queue<Frame> cached = new ConcurrentLinkedQueue<Frame>();
    private boolean finished;
    private int framesRecorded = 0;
    private Logger logger = Logger.getLogger(this.getClass().getName());
    private int cachedMaxSize = 0;
    private int toWriteMaxSize = 0;

    public JavaCVWriter(int width, int height) {
        this.width = width;
        this.height = height;
        this.finished = false;
    }

    private void writeLoop() {
        try {
            try {
                while (!this.finished) {
                    this.toWriteMaxSize = Math.max(this.toWriteMaxSize, this.toWrite.size());
                    this.cachedMaxSize = Math.max(this.cachedMaxSize, this.cached.size());
                    Frame f = this.toWrite.take();
                    this.recorder.record(f);
                    ++this.framesRecorded;
                    this.cached.add(f);
                    if ((double)this.framesRecorded % (this.framerate * 10.0) != 0.0) continue;
                    this.logger.info("Frames Recorded: " + this.framesRecorded + ". Cached max size: " + this.cachedMaxSize + ". toWriteMaxSize: " + this.toWriteMaxSize);
                }
            }
            catch (InterruptedException e) {
                this.finished = true;
                while (!this.toWrite.isEmpty()) {
                    this.recorder.record((Frame)this.toWrite.poll());
                    ++this.framesRecorded;
                }
                this.logger.info("Frames Recorded: " + this.framesRecorded);
                this.recorder.stop();
                this.recorder.release();
            }
        }
        catch (FrameRecorder.Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void start(File output) {
        try {
            this.recorder = FrameRecorder.createDefault((File)output, (int)this.width, (int)this.height);
            System.out.println(this.recorder.getClass());
            this.recorder.setFrameRate(this.framerate);
            this.recorder.setVideoQuality(0.9);
            this.executor = Executors.newSingleThreadExecutor();
            this.executor.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        JavaCVWriter.this.recorder.start();
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
            this.executor.submit(new Runnable(){

                @Override
                public void run() {
                    JavaCVWriter.this.writeLoop();
                }
            });
        }
        catch (FrameRecorder.Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void writePicture(ByteBuffer rgbaBuff) {
        Frame frame = this.newFrame();
        ByteBuffer img = (ByteBuffer)frame.image[0];
        img.clear();
        img.put(rgbaBuff);
        img.limit(rgbaBuff.limit());
        JavaCVWriter.flipY(frame);
        try {
            this.toWrite.put(frame);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private static void flipY(Frame f) {
        int height = f.imageHeight;
        int width = f.imageWidth;
        ByteBuffer buf = (ByteBuffer)f.image[0];
        for (int y = 0; y < height / 2; ++y) {
            for (int x = 0; x < width; ++x) {
                int inPtr0 = (y * width + x) * 4;
                int outPtr0 = ((height - y - 1) * width + x) * 4;
                byte b1 = buf.get(inPtr0 + 0);
                byte g1 = buf.get(inPtr0 + 1);
                byte r1 = buf.get(inPtr0 + 2);
                byte a1 = buf.get(inPtr0 + 3);
                byte b2 = buf.get(outPtr0 + 0);
                byte g2 = buf.get(outPtr0 + 1);
                byte r2 = buf.get(outPtr0 + 2);
                byte a2 = buf.get(outPtr0 + 3);
                buf.put(outPtr0 + 0, r1);
                buf.put(outPtr0 + 1, g1);
                buf.put(outPtr0 + 2, b1);
                buf.put(outPtr0 + 3, a1);
                buf.put(inPtr0 + 0, r2);
                buf.put(inPtr0 + 1, g2);
                buf.put(inPtr0 + 2, b2);
                buf.put(inPtr0 + 3, a2);
            }
        }
    }

    private Frame newFrame() {
        Frame f = this.cached.poll();
        if (f == null) {
            f = new Frame(this.width, this.height, 8, 4);
        }
        return f;
    }

    @Override
    public void stop() {
        this.executor.shutdownNow();
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public void setWidth(int width) {
        this.width = width;
        this.recorder.setImageWidth(width);
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public void setHeight(int height) {
        this.height = height;
        this.recorder.setImageHeight(height);
    }
}

