/*
 * Decompiled with CFR 0.152.
 */
package phat.util;

import com.jme3.app.Application;
import com.jme3.app.state.AbstractAppState;
import com.jme3.app.state.AppStateManager;
import com.jme3.app.state.ScreenshotAppState;
import com.jme3.input.InputManager;
import com.jme3.input.controls.ActionListener;
import com.jme3.input.controls.InputListener;
import com.jme3.input.controls.KeyTrigger;
import com.jme3.input.controls.Trigger;
import com.jme3.post.SceneProcessor;
import com.jme3.renderer.Camera;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.Renderer;
import com.jme3.renderer.ViewPort;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.system.JmeSystem;
import com.jme3.texture.FrameBuffer;
import com.jme3.texture.Image;
import com.jme3.util.BufferUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PHATScreenshotAppState
extends AbstractAppState
implements ActionListener,
SceneProcessor {
    private static final Logger logger = Logger.getLogger(ScreenshotAppState.class.getName());
    private String filePath = JmeSystem.getStorageFolder() + File.separator;
    private String fileName = "screenshot";
    private boolean capture = false;
    private Renderer renderer;
    private RenderManager rm;
    private ByteBuffer outBuf;
    private ByteBuffer imgBuf;
    private int width;
    private int height;
    private Image image;

    public void initialize(AppStateManager stateManager, Application app) {
        if (!super.isInitialized()) {
            InputManager inputManager = app.getInputManager();
            inputManager.addMapping("ScreenShot", new Trigger[]{new KeyTrigger(183)});
            inputManager.addListener((InputListener)this, new String[]{"ScreenShot"});
            List vps = app.getRenderManager().getPostViews();
            ViewPort last = (ViewPort)vps.get(vps.size() - 1);
            last.addProcessor((SceneProcessor)this);
        }
        super.initialize(stateManager, app);
    }

    public void onAction(String name, boolean value, float tpf) {
        if (value) {
            this.capture = true;
        }
    }

    public void takeScreenshot() {
        this.image = null;
        this.capture = true;
    }

    public void initialize(RenderManager rm, ViewPort vp) {
        this.renderer = rm.getRenderer();
        this.rm = rm;
        this.reshape(vp, vp.getCamera().getWidth(), vp.getCamera().getHeight());
    }

    public boolean isInitialized() {
        return super.isInitialized() && this.renderer != null;
    }

    public void reshape(ViewPort vp, int w, int h) {
        this.outBuf = BufferUtils.createByteBuffer((int)(w * h * 4));
        this.imgBuf = BufferUtils.createByteBuffer((int)(w * h * 4));
        this.width = w;
        this.height = h;
    }

    public void preFrame(float tpf) {
    }

    public void postQueue(RenderQueue rq) {
    }

    public void postFrame(FrameBuffer out) {
        if (this.capture) {
            this.capture = false;
            Camera curCamera = this.rm.getCurrentCamera();
            int viewX = (int)(curCamera.getViewPortLeft() * (float)curCamera.getWidth());
            int viewY = (int)(curCamera.getViewPortBottom() * (float)curCamera.getHeight());
            int viewWidth = (int)((curCamera.getViewPortRight() - curCamera.getViewPortLeft()) * (float)curCamera.getWidth());
            int viewHeight = (int)((curCamera.getViewPortTop() - curCamera.getViewPortBottom()) * (float)curCamera.getHeight());
            this.renderer.setViewPort(0, 0, this.width, this.height);
            this.renderer.readFrameBuffer(out, this.outBuf);
            this.renderer.setViewPort(viewX, viewY, viewWidth, viewHeight);
            for (int i = 0; i < this.width * this.height * 4; i += 4) {
                byte r = this.outBuf.get(i);
                byte g = this.outBuf.get(i + 1);
                byte b = this.outBuf.get(i + 2);
                byte a = this.outBuf.get(i + 3);
                this.imgBuf.put(i, b);
                this.imgBuf.put(i + 1, g);
                this.imgBuf.put(i + 2, r);
                this.imgBuf.put(i + 3, a);
            }
            this.image = new Image(Image.Format.RGBA8, this.width, this.height, this.imgBuf);
        }
    }

    public boolean isImageReady() {
        return this.image != null;
    }

    public Image getImage() {
        return this.image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveScreenshot() {
        File file = new File(this.getFilePath() + this.getFileName() + ".png").getAbsoluteFile();
        logger.log(Level.INFO, "Saving ScreenShot to: {0}", file.getAbsolutePath());
        FileOutputStream outStream = null;
        try {
            outStream = new FileOutputStream(file);
            JmeSystem.writeImageFile((OutputStream)outStream, (String)"png", (ByteBuffer)this.outBuf, (int)this.width, (int)this.height);
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, "Error while saving screenshot", ex);
        }
        finally {
            if (outStream != null) {
                try {
                    ((OutputStream)outStream).close();
                }
                catch (IOException ex) {
                    logger.log(Level.SEVERE, "Error while saving screenshot", ex);
                }
            }
        }
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
        if (!this.filePath.endsWith(File.separator)) {
            this.filePath = this.filePath + File.separator;
        }
    }

    public String getFilePath() {
        return this.filePath;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getFileName() {
        return this.fileName;
    }
}

