/*
 * Decompiled with CFR 0.152.
 */
package phat.util;

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.WritableRaster;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.RecursiveAction;

public class ConvertBgraToAbgr
extends RecursiveAction {
    private int mStart;
    private int mLength;
    private byte[] outArray;
    private byte[] inArray;
    int width;
    int height;
    protected static int sThreshold = 200;
    public static Map<Integer, byte[]> buffers = new HashMap<Integer, byte[]>();

    public ConvertBgraToAbgr(byte[] src, int start, int length, byte[] dst, int width, int height) {
        this.inArray = src;
        this.mStart = start;
        this.mLength = length;
        this.outArray = dst;
        this.width = width;
        this.height = height;
    }

    protected void computeDirectly() {
        for (int y = this.mStart; y < this.mStart + this.mLength; ++y) {
            int yAux = y * this.width;
            for (int x = 0; x < this.width; ++x) {
                int inPtr = (yAux + x) * 4;
                int outPtr = ((this.height - y - 1) * this.width + x) * 4;
                this.outArray[outPtr + 1] = this.inArray[inPtr + 0];
                this.outArray[outPtr + 2] = this.inArray[inPtr + 1];
                this.outArray[outPtr + 3] = this.inArray[inPtr + 2];
                this.outArray[outPtr + 0] = this.inArray[inPtr + 3];
            }
        }
    }

    @Override
    protected void compute() {
        if (this.mLength < sThreshold) {
            this.computeDirectly();
            return;
        }
        int split = this.mLength / 2;
        ConvertBgraToAbgr.invokeAll(new ConvertBgraToAbgr(this.inArray, this.mStart, split, this.outArray, this.width, this.height), new ConvertBgraToAbgr(this.inArray, this.mStart + split, this.mLength - split, this.outArray, this.width, this.height));
    }

    private static byte[] getBuffer(int length) {
        byte[] result = buffers.get(length);
        if (result == null) {
            result = new byte[length];
            buffers.put(length, result);
        }
        return result;
    }

    public static void convert(ByteBuffer bgraBuf, BufferedImage out) {
        WritableRaster wr = out.getRaster();
        DataBufferByte db = (DataBufferByte)wr.getDataBuffer();
        byte[] dst = db.getData();
        byte[] src = ConvertBgraToAbgr.getBuffer(dst.length);
        bgraBuf.clear();
        bgraBuf.get(src);
        bgraBuf.clear();
        int width = wr.getWidth();
        int height = wr.getHeight();
        ConvertBgraToAbgr fb = new ConvertBgraToAbgr(src, 0, height, dst, width, height);
        fb.computeDirectly();
    }
}

