/*
 * Decompiled with CFR 0.152.
 */
package phat.sensors;

import com.jme3.scene.Spatial;
import com.jme3.scene.control.AbstractControl;
import com.jme3.scene.control.Control;
import java.util.ArrayList;
import java.util.List;
import phat.sensors.SensorData;
import phat.sensors.SensorDataFilter;
import phat.sensors.SensorListener;
import phat.sensors.SensorNotificationLauncher;

public abstract class Sensor
extends AbstractControl {
    protected String id;
    protected List<SensorListener> listeners;
    protected List<SensorDataFilter> filters;
    SensorNotificationLauncher launcher;

    public Sensor(String id) {
        this.id = id;
        this.listeners = new ArrayList<SensorListener>();
        this.launcher = new SensorNotificationLauncher(this.listeners, this);
        this.filters = new ArrayList<SensorDataFilter>();
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public void add(SensorListener sensorListener) {
        if (!this.listeners.contains(sensorListener)) {
            this.listeners.add(sensorListener);
            if (!this.isEnabled()) {
                this.setEnabled(true);
            }
        }
    }

    public void addFilter(SensorDataFilter filter) {
        this.filters.add(filter);
    }

    public boolean hasListener(SensorListener sl) {
        return this.listeners.contains(sl);
    }

    public void remove(SensorListener sensorListener) {
        this.listeners.remove(sensorListener);
        if (this.listeners.isEmpty() && this.isEnabled()) {
            this.setEnabled(false);
        }
    }

    protected void notifyListeners(SensorData sensorData) {
        SensorData sd = sensorData;
        for (SensorDataFilter filter : this.filters) {
            sd = filter.filter(sd);
        }
        this.launcher.notify(sd);
    }

    protected Control cloneControl(Control control, Spatial spatial) {
        if (control instanceof Sensor) {
            Sensor sensor = (Sensor)control;
            sensor.setId(this.id);
            sensor.listeners.addAll(this.listeners);
        }
        return control;
    }

    public void cleanUp() {
        for (SensorListener sl : this.listeners) {
            sl.cleanUp();
        }
        this.listeners.clear();
    }
}

