/*
 * Decompiled with CFR 0.152.
 */
package phat.util;

import com.jme3.asset.AssetManager;
import com.jme3.font.BitmapFont;
import com.jme3.font.BitmapText;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.VertexBuffer;
import com.jme3.scene.control.BillboardControl;
import com.jme3.scene.control.Control;
import com.jme3.scene.debug.Arrow;
import com.jme3.scene.shape.Box;
import com.jme3.texture.Texture;
import com.jme3.util.BufferUtils;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SpatialFactory {
    private static final Logger logger = Logger.getLogger(SpatialFactory.class.getName());
    private static AssetManager assetManager;
    private static Node rootNode;

    public static void init(AssetManager assetManager, Node rootNode) {
        SpatialFactory.assetManager = assetManager;
        SpatialFactory.rootNode = rootNode;
    }

    public static AssetManager getAssetManager() {
        return assetManager;
    }

    public static Node getRootNode() {
        return rootNode;
    }

    public static Geometry createCube(Vector3f dimensions, ColorRGBA color) {
        SpatialFactory.checkInit();
        Box b = new Box(dimensions.getX(), dimensions.getY(), dimensions.getZ());
        Geometry geom = new Geometry("Box", (Mesh)b);
        Material mat = new Material(assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
        mat.setColor("Color", color);
        geom.setMaterial(mat);
        return geom;
    }

    public static Geometry createArrow(Vector3f dir, float lineWidth, ColorRGBA color) {
        Arrow arrow = new Arrow(dir);
        arrow.setLineWidth(lineWidth);
        return SpatialFactory.createShape("Arrow", (Mesh)arrow, color);
    }

    public static Geometry createShape(String name, Mesh shape, ColorRGBA color) {
        SpatialFactory.checkInit();
        Geometry g = new Geometry(name, shape);
        Material mat = new Material(assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
        mat.getAdditionalRenderState().setWireframe(true);
        mat.setColor("Color", color);
        g.setMaterial(mat);
        return g;
    }

    public static BitmapText attachAName(Node node) {
        SpatialFactory.checkInit();
        return SpatialFactory.attachAName(node, node.getName());
    }

    public static BitmapText attachAName(Node node, String name) {
        SpatialFactory.checkInit();
        BitmapFont guiFont = assetManager.loadFont("Interface/Fonts/Default.fnt");
        BitmapText ch = new BitmapText(guiFont, false);
        ch.setName("BitmapText");
        ch.setSize((float)guiFont.getCharSet().getRenderedSize() * 0.02f);
        ch.setText(name);
        ch.setColor(new ColorRGBA(1.0f, 0.8f, 0.3f, 0.8f));
        ch.getLocalScale().divideLocal(node.getLocalScale());
        BillboardControl control = new BillboardControl();
        ch.addControl((Control)control);
        node.attachChild((Spatial)ch);
        return ch;
    }

    public static Geometry createImageTextureSurface(String imgPath, float width, float height) {
        Mesh m = new Mesh();
        Vector3f[] vertices = new Vector3f[]{new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(width, 0.0f, 0.0f), new Vector3f(0.0f, height, 0.0f), new Vector3f(width, height, 0.0f)};
        Vector2f[] texCoord = new Vector2f[]{new Vector2f(0.0f, 0.0f), new Vector2f(1.0f, 0.0f), new Vector2f(0.0f, 1.0f), new Vector2f(1.0f, 1.0f)};
        int[] indexes = new int[]{2, 0, 1, 1, 3, 2};
        m.setBuffer(VertexBuffer.Type.Position, 3, BufferUtils.createFloatBuffer((Vector3f[])vertices));
        m.setBuffer(VertexBuffer.Type.TexCoord, 2, BufferUtils.createFloatBuffer((Vector2f[])texCoord));
        m.setBuffer(VertexBuffer.Type.Index, 1, BufferUtils.createIntBuffer((int[])indexes));
        m.updateBound();
        Geometry geom = new Geometry("OurMesh", m);
        Material mat = new Material(assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
        Texture cube1Tex = assetManager.loadTexture(imgPath);
        mat.setTexture("ColorMap", cube1Tex);
        geom.setMaterial(mat);
        return geom;
    }

    private static void checkInit() {
        if (assetManager == null) {
            logger.log(Level.SEVERE, "Method SpatialFactory.init() hasn't been called");
        }
    }

    public static boolean contains(Node parent, Spatial s) {
        for (Spatial aux = s; aux != null; aux = aux.getParent()) {
            if (!aux.equals(parent)) continue;
            return true;
        }
        return false;
    }
}

