/*
 * Decompiled with CFR 0.152.
 */
package phat.util;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;

public class PHATImageUtils {
    public static byte[] bufferedImageToJPGByteArray(BufferedImage image) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)image, "jpg", baos);
            byte[] imageInByte = baos.toByteArray();
            return imageInByte;
        }
        catch (IOException ex) {
            Logger.getLogger(PHATImageUtils.class.getName()).log(Level.SEVERE, "bufferedImageToByteArray", ex);
            return null;
        }
    }

    public static void printImageFormatNames() {
        System.out.println("Informa Names:");
        for (String s : ImageIO.getReaderFormatNames()) {
            System.out.println(s);
        }
    }

    public static byte[] bufferedImageToBMPByteArray(BufferedImage image, BufferedImage bufferedImage) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            Graphics2D ngraphics = (Graphics2D)bufferedImage.getGraphics();
            ngraphics.drawImage((Image)image, 0, 0, null);
            ImageIO.write((RenderedImage)bufferedImage, "bmp", baos);
            baos.flush();
            byte[] imageInByte = baos.toByteArray();
            baos.close();
            return imageInByte;
        }
        catch (IOException ex) {
            Logger.getLogger(PHATImageUtils.class.getName()).log(Level.SEVERE, "bufferedImageToByteArray", ex);
            return null;
        }
    }

    public static void convertABGRToRGB(BufferedImage image, int[] buffer) {
        if (image.getType() != 6) {
            return;
        }
        WritableRaster wr = image.getRaster();
        DataBufferByte db = (DataBufferByte)wr.getDataBuffer();
        byte[] inArray = db.getData();
        int offset = 0;
        for (int i = 0; i < buffer.length; ++i) {
            buffer[i] = inArray[1 + offset] & 0xFF | (inArray[2 + offset] & 0xFF) << 8 | (inArray[3 + offset] & 0xFF) << 16 | (inArray[0 + offset] & 0xFF) << 24;
            offset += 4;
        }
    }

    public static byte[] convertABGRToRGB565(BufferedImage image, BufferedImage bufferedImage) {
        if (image.getType() != 6) {
            return null;
        }
        Graphics2D ngraphics = (Graphics2D)bufferedImage.getGraphics();
        ngraphics.drawImage((Image)image, 0, 0, null);
        WritableRaster wr = image.getRaster();
        DataBufferByte db = (DataBufferByte)wr.getDataBuffer();
        return db.getData();
    }

    public static byte[] bufferedImageToFormat(BufferedImage image, String formatName) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ImageIO.setUseCache(false);
            ImageIO.write((RenderedImage)image, formatName, baos);
            baos.flush();
            byte[] imageInByte = baos.toByteArray();
            baos.close();
            return imageInByte;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            Logger.getLogger(PHATImageUtils.class.getName()).log(Level.SEVERE, "bufferedImageToByteArray", ex);
            return null;
        }
    }

    public static byte[] bufferedImageToFormat(BufferedImage image, String formatName, ByteArrayOutputStream baos) {
        try {
            baos.reset();
            ImageIO.setUseCache(false);
            ImageIO.write((RenderedImage)image, formatName, baos);
            baos.flush();
            byte[] imageInByte = baos.toByteArray();
            baos.close();
            return imageInByte;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            Logger.getLogger(PHATImageUtils.class.getName()).log(Level.SEVERE, "bufferedImageToByteArray", ex);
            return null;
        }
    }

    public static void getScreenShotBGRA(ByteBuffer bgraBuf, BufferedImage out) {
        WritableRaster wr = out.getRaster();
        DataBufferByte db = (DataBufferByte)wr.getDataBuffer();
        byte[] cpuArray = db.getData();
        bgraBuf.clear();
        bgraBuf.get(cpuArray);
        bgraBuf.clear();
    }

    public static void getScreenShotABGR(ByteBuffer bgraBuf, BufferedImage out) {
        WritableRaster wr = out.getRaster();
        DataBufferByte db = (DataBufferByte)wr.getDataBuffer();
        byte[] cpuArray = db.getData();
        bgraBuf.clear();
        bgraBuf.get(cpuArray);
        bgraBuf.clear();
        int width = wr.getWidth();
        int height = wr.getHeight();
        for (int y = 0; y < height / 2; ++y) {
            for (int x = 0; x < width; ++x) {
                int inPtr = (y * width + x) * 4;
                int outPtr = ((height - y - 1) * width + x) * 4;
                byte b1 = cpuArray[inPtr + 0];
                byte g1 = cpuArray[inPtr + 1];
                byte r1 = cpuArray[inPtr + 2];
                byte a1 = cpuArray[inPtr + 3];
                byte b2 = cpuArray[outPtr + 0];
                byte g2 = cpuArray[outPtr + 1];
                byte r2 = cpuArray[outPtr + 2];
                byte a2 = cpuArray[outPtr + 3];
                cpuArray[outPtr + 0] = a1;
                cpuArray[outPtr + 1] = b1;
                cpuArray[outPtr + 2] = g1;
                cpuArray[outPtr + 3] = r1;
                cpuArray[inPtr + 0] = a2;
                cpuArray[inPtr + 1] = b2;
                cpuArray[inPtr + 2] = g2;
                cpuArray[inPtr + 3] = r2;
            }
        }
    }

    public static byte[] convertABGRToYUV220SP(BufferedImage image) {
        int numpixels;
        byte[] oneFrame = new byte[(int)((double)(image.getWidth() * image.getHeight()) * 1.5)];
        WritableRaster wr = image.getRaster();
        DataBufferByte db = (DataBufferByte)wr.getDataBuffer();
        byte[] inArray = db.getData();
        int width = wr.getWidth();
        int height = wr.getHeight();
        int i = 0;
        int ui = numpixels = width * height;
        int vi = numpixels + numpixels / 4;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int inPtr = (y * width + x) * 4;
                int color = image.getRGB(x, y);
                byte R = inArray[inPtr + 3];
                byte G = inArray[inPtr + 2];
                byte B = inArray[inPtr + 1];
                int Y = (int)(0.257 * (double)R + 0.504 * (double)G + 0.098 * (double)B + 16.0);
                oneFrame[i] = (byte)Y;
                if (0 == y % 2 && 0 == x % 2) {
                    oneFrame[vi++] = (byte)(0.439 * (double)R - 0.368 * (double)G - 0.071 * (double)B + 128.0);
                    oneFrame[ui++] = (byte)(-(0.148 * (double)R) - 0.291 * (double)G + 0.439 * (double)B + 128.0);
                }
                ++i;
            }
        }
        return oneFrame;
    }

    public static void main(String[] args) throws IOException {
        int i;
        HashSet<String> set = new HashSet<String>();
        String[] formatNames = ImageIO.getReaderFormatNames();
        for (i = 0; i < formatNames.length; ++i) {
            set.add(formatNames[i].toLowerCase());
        }
        System.out.println("Supported read formats: " + set);
        set.clear();
        formatNames = ImageIO.getWriterFormatNames();
        for (i = 0; i < formatNames.length; ++i) {
            set.add(formatNames[i].toLowerCase());
        }
        System.out.println("Supported write formats: " + set);
        set.clear();
        formatNames = ImageIO.getReaderMIMETypes();
        for (i = 0; i < formatNames.length; ++i) {
            set.add(formatNames[i].toLowerCase());
        }
        System.out.println("Supported read MIME types: " + set);
        set.clear();
        formatNames = ImageIO.getWriterMIMETypes();
        for (i = 0; i < formatNames.length; ++i) {
            set.add(formatNames[i].toLowerCase());
        }
        System.out.println("Supported write MIME types: " + set);
    }
}

