/*
 * Decompiled with CFR 0.152.
 */
package phat.sensors.camera;

import com.jme3.bullet.control.RigidBodyControl;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector3f;
import com.jme3.post.SceneProcessor;
import com.jme3.renderer.Camera;
import com.jme3.renderer.ViewPort;
import com.jme3.scene.CameraNode;
import com.jme3.scene.Geometry;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.control.CameraControl;
import com.jme3.scene.control.Control;
import com.jme3.system.AppSettings;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFrame;
import phat.sensors.camera.CameraSensor;
import phat.sensors.camera.CameraSensorListenerFrame;
import phat.util.Debug;
import phat.util.SimpleScenario;
import phat.util.SpatialFactory;

public class CameraSensorAppTest
extends SimpleScenario {
    List<JFrame> frames = new ArrayList<JFrame>();
    Camera smartPhoneCamera;
    CameraNode cameraNode;

    public static void main(String[] args) {
        Logger.getGlobal().setLevel(Level.ALL);
        CameraSensorAppTest app = new CameraSensorAppTest();
        app.setPauseOnLostFocus(false);
        app.setShowSettings(false);
        AppSettings settings = new AppSettings(true);
        settings.setWidth(480);
        settings.setHeight(800);
        app.setSettings(settings);
        app.start();
    }

    @Override
    public void simpleInitApp() {
        super.simpleInitApp();
    }

    @Override
    public void createTerrain() {
        Debug.enableDebugGrid(10.0f, this.assetManager, this.rootNode);
        Vector3f dimensions = new Vector3f(10.0f, 0.1f, 10.0f);
        Geometry floor = SpatialFactory.createCube(dimensions, ColorRGBA.Gray);
        RigidBodyControl rbc = new RigidBodyControl(0.0f);
        floor.setLocalTranslation(new Vector3f(0.0f, -0.1f, 0.0f));
        floor.addControl((Control)rbc);
        this.bulletAppState.getPhysicsSpace().add((Object)rbc);
        this.rootNode.attachChild((Spatial)floor);
    }

    public void simpleUpdate(float tpf) {
        super.simpleUpdate(tpf);
    }

    @Override
    public void createOtherObjects() {
        this.createSmartphone("Smartphone1", new Vector3f(0.0f, 5.0f, 0.0f), ColorRGBA.Pink);
        this.createSmartphone("Smartphone2", new Vector3f(0.0f, 5.0f, 2.0f), ColorRGBA.Cyan);
    }

    private void createSmartphone(String smartphoneId, Vector3f loc, ColorRGBA color) {
        Node smartphone = new Node(smartphoneId);
        smartphone.setLocalTranslation(loc);
        Geometry geo = SpatialFactory.createCube(Vector3f.UNIT_XYZ.mult(0.1f), color);
        smartphone.attachChild((Spatial)geo);
        RigidBodyControl rbc = new RigidBodyControl(1.0f);
        smartphone.addControl((Control)rbc);
        this.smartPhoneCamera = this.cam.clone();
        this.smartPhoneCamera.setFrustumPerspective(45.0f, (float)this.cam.getWidth() / (float)this.cam.getHeight(), 0.1f, 1000.0f);
        this.cameraNode = this.createCameraNode(this.smartPhoneCamera);
        smartphone.attachChild((Spatial)this.cameraNode);
        ViewPort vp = this.createViewPort(this.smartPhoneCamera);
        int width = vp.getCamera().getWidth();
        int height = vp.getCamera().getHeight();
        CameraSensor cp = new CameraSensor("CameraSensor-" + smartphone.getName());
        vp.addProcessor((SceneProcessor)cp);
        CameraSensorListenerFrame cameraFrame = new CameraSensorListenerFrame();
        cp.add(cameraFrame);
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(3);
        frame.setSize(480, 800);
        frame.setVisible(true);
        frame.setContentPane(cameraFrame);
        this.frames.add(frame);
        this.bulletAppState.getPhysicsSpace().addAll((Spatial)smartphone);
        this.rootNode.attachChild((Spatial)smartphone);
    }

    private ViewPort createViewPort(Camera smartPhoneCamera) {
        float xFactor = (float)this.cam.getWidth() / (float)smartPhoneCamera.getWidth();
        float yFactor = (float)this.cam.getHeight() / (float)smartPhoneCamera.getHeight();
        smartPhoneCamera.setViewPort(0.0f * xFactor, 1.0f * xFactor, 0.0f * yFactor, 1.0f * yFactor);
        ViewPort vp = this.renderManager.createPreView("asdf", smartPhoneCamera);
        vp.setClearFlags(true, true, true);
        vp.setBackgroundColor(ColorRGBA.White);
        vp.attachScene((Spatial)SpatialFactory.getRootNode());
        return vp;
    }

    private CameraNode createCameraNode(Camera smartPhoneCamera) {
        CameraNode camNode = new CameraNode("Camera Node", smartPhoneCamera);
        camNode.setControlDir(CameraControl.ControlDirection.SpatialToCamera);
        camNode.setLocalTranslation(new Vector3f(0.0f, 0.0f, 0.0f));
        return camNode;
    }

    public void destroy() {
        super.destroy();
        for (JFrame f : this.frames) {
            f.dispose();
        }
    }
}

