/*
 * Decompiled with CFR 0.152.
 */
package phat.sensors.accelerometer;

import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector3f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.VertexBuffer;
import com.jme3.scene.shape.Line;
import phat.sensors.Sensor;
import phat.sensors.SensorData;
import phat.sensors.SensorListener;
import phat.util.SpatialFactory;

public class ShowAxes
implements SensorListener {
    Line axeX;
    Line axeY;
    Line axeZ;
    Node parent;
    float scalar;

    public ShowAxes(Node parent) {
        this.parent = parent;
        this.showAccelerationAxes();
    }

    private void showAccelerationAxes() {
        Vector3f start = this.parent.getWorldTranslation();
        this.axeX = this.createLinesAxe(start, start.mult(new Vector3f(1.0f + this.scalar, 1.0f, 1.0f)), 0);
        this.axeY = this.createLinesAxe(start, start.mult(new Vector3f(1.0f, 1.0f + this.scalar, 1.0f)), 1);
        this.axeZ = this.createLinesAxe(start, start.mult(new Vector3f(1.0f, 1.0f, 1.0f + this.scalar)), 2);
    }

    private Mesh createAxes(Vector3f start, Vector3f end, int axe) {
        Mesh lineMesh = new Mesh();
        lineMesh.setMode(Mesh.Mode.Lines);
        lineMesh.setBuffer(VertexBuffer.Type.Position, 3, new float[]{start.getX(), start.getY(), start.getZ(), end.getX(), end.getY(), end.getZ()});
        lineMesh.setBuffer(VertexBuffer.Type.Index, 2, new short[]{0, 1});
        Geometry lineGeometry = new Geometry("line", lineMesh);
        Material lineMaterial = new Material(SpatialFactory.getAssetManager(), "Common/MatDefs/Misc/Unshaded.j3md");
        lineMaterial.getAdditionalRenderState().setWireframe(true);
        lineMaterial.getAdditionalRenderState().setDepthTest(false);
        switch (axe) {
            case 0: {
                lineMaterial.setColor("Color", ColorRGBA.Red);
                break;
            }
            case 1: {
                lineMaterial.setColor("Color", ColorRGBA.Blue);
                break;
            }
            case 2: {
                lineMaterial.setColor("Color", ColorRGBA.Green);
            }
        }
        lineGeometry.setMaterial(lineMaterial);
        SpatialFactory.getRootNode().attachChild((Spatial)lineGeometry);
        return lineMesh;
    }

    private Line createLinesAxe(Vector3f start, Vector3f end, int axe) {
        Line line = new Line(start, end);
        line.setLineWidth(1.0f);
        Geometry lineGeometry = new Geometry("line" + axe, (Mesh)line);
        Material lineMaterial = new Material(SpatialFactory.getAssetManager(), "Common/MatDefs/Misc/Unshaded.j3md");
        lineMaterial.getAdditionalRenderState().setWireframe(true);
        lineMaterial.getAdditionalRenderState().setDepthTest(false);
        switch (axe) {
            case 0: {
                lineMaterial.setColor("Color", ColorRGBA.Red);
                break;
            }
            case 1: {
                lineMaterial.setColor("Color", ColorRGBA.Blue);
                break;
            }
            case 2: {
                lineMaterial.setColor("Color", ColorRGBA.Green);
            }
        }
        lineGeometry.setMaterial(lineMaterial);
        SpatialFactory.getRootNode().attachChild((Spatial)lineGeometry);
        return line;
    }

    private Material generateMaterial(int axe) {
        Material lineMaterial = new Material(SpatialFactory.getAssetManager(), "Common/MatDefs/Misc/Unshaded.j3md");
        lineMaterial.getAdditionalRenderState().setWireframe(true);
        lineMaterial.getAdditionalRenderState().setDepthTest(false);
        switch (axe) {
            case 0: {
                lineMaterial.setColor("Color", ColorRGBA.Red);
                break;
            }
            case 1: {
                lineMaterial.setColor("Color", ColorRGBA.Blue);
                break;
            }
            case 2: {
                lineMaterial.setColor("Color", ColorRGBA.Green);
            }
        }
        return lineMaterial;
    }

    public void updateIncrementalAcceleration(float time, float[] accelerations) {
    }

    @Override
    public void update(Sensor source, SensorData sd) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void cleanUp() {
        this.axeX = null;
        this.axeY = null;
        this.axeZ = null;
        this.parent = null;
    }
}

