/*
 * Decompiled with CFR 0.152.
 */
package phat.sensors.accelerometer;

import com.jme3.bullet.control.RigidBodyControl;
import com.jme3.math.FastMath;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.ViewPort;
import com.jme3.scene.Spatial;
import com.jme3.scene.control.Control;
import phat.sensors.Sensor;
import phat.sensors.SensorListener;
import phat.sensors.accelerometer.AccelerationData;

public class AccelerometerControl
extends Sensor {
    boolean added;
    float accuracy = 0.033333335f;
    float time = 0.0f;
    RigidBodyControl rbc;
    private float maxAccelerationRange = 40.0f;
    private Vector3f lastLocation;
    private Vector3f lastVelocity = new Vector3f(0.0f, 0.0f, 0.0f);
    private Quaternion lastRotation;
    Vector3f acceleration = new Vector3f();
    Vector3f currentVelocity = new Vector3f();
    Vector3f currentLocation = new Vector3f();
    Vector3f displacement = new Vector3f();
    Vector3f lastAcc = new Vector3f();
    AMode mode = AMode.GRAVITY_MODE;
    float[] angles = new float[3];
    Vector3f gravity = new Vector3f();
    Vector3f abs = new Vector3f();

    public AccelerometerControl(String id) {
        super(id);
        this.lastLocation = new Vector3f();
        this.lastRotation = new Quaternion();
    }

    public void setSpatial(Spatial spatial) {
        super.setSpatial(spatial);
        if (spatial == null) {
            return;
        }
        this.rbc = (RigidBodyControl)spatial.getControl(RigidBodyControl.class);
        this.lastLocation.set(this.getLocation());
        this.lastRotation.set(this.getRotation());
    }

    private Vector3f getLocation() {
        if (this.rbc != null && this.rbc.isEnabled()) {
            return this.rbc.getPhysicsLocation();
        }
        return this.spatial.getWorldTranslation();
    }

    private Quaternion getRotation() {
        if (this.rbc.isEnabled()) {
            return this.rbc.getPhysicsRotation();
        }
        return this.spatial.getWorldRotation();
    }

    private Quaternion desfase(Quaternion ini, Quaternion end) {
        Quaternion result = null;
        Vector3f endAngles = new Vector3f();
        end.toAngleAxis(endAngles);
        Vector3f iniAngles = new Vector3f();
        ini.toAngleAxis(iniAngles);
        Vector3f angles = endAngles.subtract(iniAngles);
        float[] buffer = new float[3];
        result = new Quaternion(angles.toArray(buffer));
        return result;
    }

    private void updateIncrementalListeners(float time, Vector3f accelerations) {
        AccelerationData ad = new AccelerationData(time, accelerations.getX(), accelerations.getY(), accelerations.getZ());
        for (SensorListener al : this.listeners) {
            al.update(this, ad);
        }
    }

    private float filter(float a) {
        float max = this.maxAccelerationRange / 2.0f;
        if (a > max) {
            a = max;
        } else if (a < -max) {
            a = -max;
        }
        return a;
    }

    protected void controlUpdate(float tpf) {
        this.time += tpf;
        if (this.time > this.accuracy) {
            this.calculateAccelerations(this.time);
            this.time = 0.0f;
        }
    }

    protected void controlRender(RenderManager rm, ViewPort vp) {
    }

    public Control cloneForSpatial(Spatial spatial) {
        return null;
    }

    private void printAngles(Quaternion q) {
        q.toAngles(this.angles);
        System.out.println("x=" + Math.round(57.295776f * this.angles[0]) + "; y=" + Math.round(57.295776f * this.angles[1]) + "; z=" + Math.round(57.295776f * this.angles[2]));
    }

    private void calculateAccelerations(float time) {
        Quaternion rot = this.getRotation();
        this.currentLocation.set(this.getLocation());
        this.lastLocation.subtract(this.currentLocation, this.currentVelocity);
        this.currentVelocity.divideLocal(time);
        this.calculateGravity(rot);
        switch (this.mode) {
            case GRAVITY_MODE: {
                this.updateIncrementalListeners(time, this.gravity);
                break;
            }
            case ACCELEROMETER_MODE: {
                this.currentVelocity.subtract(this.lastVelocity, this.acceleration);
                this.acceleration.divideLocal(time);
                rot.mult(this.acceleration, this.acceleration);
                this.acceleration.negateLocal();
                this.acceleration.addLocal(this.gravity);
                if (this.acceleration.length() > 15.0f) {
                    this.acceleration.set(this.lastAcc);
                }
                this.updateIncrementalListeners(time, this.acceleration);
            }
        }
        this.lastLocation.set(this.currentLocation);
        this.lastVelocity.set(this.currentVelocity);
        this.lastAcc.set(this.acceleration);
    }

    private void calculateGravity(Quaternion rot) {
        this.gravity.set(0.0f, 9.8f, 0.0f);
        float x = this.gravity.dot(rot.getRotationColumn(0));
        float y = this.gravity.dot(rot.getRotationColumn(1));
        float z = this.gravity.dot(rot.getRotationColumn(2));
        this.gravity.set(x, y, z);
    }

    private boolean normalValue(Vector3f acc) {
        float threshold = 15.0f;
        return !(FastMath.abs((float)acc.x) > threshold) && !(FastMath.abs((float)acc.y) > threshold) && !(FastMath.abs((float)acc.z) > threshold);
    }

    private void filter(Vector3f acc) {
        float threshold = 15.0f;
        if (acc.x > threshold) {
            acc.x = threshold;
        } else if (acc.x < -threshold) {
            acc.x = -threshold;
        }
        if (acc.y > threshold) {
            acc.y = threshold;
        } else if (acc.y < -threshold) {
            acc.y = -threshold;
        }
        if (acc.z > threshold) {
            acc.z = threshold;
        } else if (acc.z < -threshold) {
            acc.z = -threshold;
        }
    }

    public AMode getMode() {
        return this.mode;
    }

    public void setMode(AMode mode) {
        this.mode = mode;
    }

    public static enum AMode {
        GRAVITY_MODE,
        ACCELEROMETER_MODE;

    }
}

