/*
 * Decompiled with CFR 0.152.
 */
package phat.sensors;

import java.util.ArrayList;
import java.util.List;
import phat.sensors.Sensor;
import phat.sensors.SensorData;
import phat.sensors.SensorListener;
import phat.sensors.SensorNotificator;

public class SensorNotificationLauncher {
    List<SensorListener> listeners;
    List<SensorNotificator> notificators = new ArrayList<SensorNotificator>();
    Sensor sensor;
    long counter = 0L;

    public SensorNotificationLauncher(List<SensorListener> listeners, Sensor sensor) {
        this.listeners = listeners;
        this.sensor = sensor;
    }

    public synchronized void notify(SensorData data) {
        ++this.counter;
        this.notificators.clear();
        for (SensorListener sl : this.listeners) {
            SensorNotificator sn = new SensorNotificator(this.sensor, data, sl);
            this.notificators.add(sn);
            sn.start();
        }
    }

    private boolean isFinished() {
        for (SensorNotificator sn : this.notificators) {
            if (sn.isFinished) continue;
            return false;
        }
        return true;
    }
}

