/*
 * Decompiled with CFR 0.152.
 */
package phat.util;

import com.jme3.bounding.BoundingBox;
import com.jme3.bounding.BoundingSphere;
import com.jme3.bounding.BoundingVolume;
import com.jme3.bullet.control.AbstractPhysicsControl;
import com.jme3.math.Vector3f;
import com.jme3.scene.Node;
import com.jme3.scene.SceneGraphVisitor;
import com.jme3.scene.Spatial;
import com.jme3.scene.control.AbstractControl;
import com.jme3.scene.control.Control;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import phat.util.PHATSceneGraphVisitor;

public class SpatialUtils {
    public static Vector3f getCenterBoinding(Spatial spatial) {
        spatial.updateModelBound();
        BoundingVolume wb = spatial.getWorldBound();
        if (wb == null) {
            return spatial.getWorldTranslation();
        }
        return wb.getCenter();
    }

    public static Vector3f getMaxBounding(Spatial spatial) {
        spatial.updateModelBound();
        BoundingVolume wb = spatial.getWorldBound();
        if (wb instanceof BoundingBox) {
            BoundingBox bb = (BoundingBox)wb;
            Vector3f max = new Vector3f();
            return bb.getMax(max);
        }
        if (wb instanceof BoundingSphere) {
            BoundingSphere bs = (BoundingSphere)wb;
            float radius = bs.getRadius();
            return new Vector3f(radius, radius, radius);
        }
        return spatial.getWorldTranslation();
    }

    public static Vector3f getMinBounding(Spatial spatial) {
        spatial.updateModelBound();
        BoundingVolume wb = spatial.getWorldBound();
        if (wb instanceof BoundingBox) {
            BoundingBox bb = (BoundingBox)wb;
            Vector3f min = new Vector3f();
            return bb.getMin(min);
        }
        if (wb instanceof BoundingSphere) {
            BoundingSphere bs = (BoundingSphere)wb;
            float radius = bs.getRadius();
            return new Vector3f(-radius, -radius, -radius);
        }
        return spatial.getWorldTranslation();
    }

    public static boolean contains(Spatial container, Spatial entity) {
        container.updateModelBound();
        Vector3f min = SpatialUtils.getMinBounding(container);
        Vector3f max = SpatialUtils.getMaxBounding(container);
        Vector3f center = SpatialUtils.getCenterBoinding(entity);
        return min.x <= center.x && min.y <= center.y && min.z <= center.z && max.x >= center.x && max.y >= center.y && max.z >= center.z;
    }

    public static boolean breadthFirstTraversal(Spatial spatial, PHATSceneGraphVisitor visitor) {
        ArrayList<Spatial> notVisited = new ArrayList<Spatial>();
        notVisited.add(spatial);
        while (!notVisited.isEmpty()) {
            Spatial s = (Spatial)notVisited.get(0);
            notVisited.remove(0);
            if (visitor.visit(s)) {
                return true;
            }
            if (!(s instanceof Node)) continue;
            Node n = (Node)s;
            notVisited.addAll(notVisited.size(), n.getChildren());
        }
        return false;
    }

    public static Node getRootNode(Spatial spatial) {
        if (spatial.getParent() == null) {
            return null;
        }
        Node result = spatial.getParent();
        while (result.getParent() != null) {
            result = result.getParent();
        }
        return result;
    }

    public static Spatial getSpatialById(Spatial rootNode, final String entityId) {
        Spatial result = null;
        PHATSceneGraphVisitor visitor = new PHATSceneGraphVisitor(){
            Spatial result = null;

            @Override
            public boolean visit(Spatial spat) {
                String id = (String)spat.getUserData("ID");
                if (id != null && id.equals(entityId)) {
                    this.result = spat;
                    return true;
                }
                return false;
            }

            @Override
            public Spatial getSpatial() {
                return this.result;
            }
        };
        if (SpatialUtils.breadthFirstTraversal(rootNode, visitor)) {
            return visitor.getSpatial();
        }
        return result;
    }

    public static Map<String, Spatial> getAllSpatialWithId(Spatial rootNode, final Map<String, Spatial> store) {
        SceneGraphVisitor visitor = new SceneGraphVisitor(){

            public void visit(Spatial spat) {
                String id = (String)spat.getUserData("ID");
                if (id != null) {
                    store.put(id, spat);
                }
            }
        };
        rootNode.breadthFirstTraversal(visitor);
        return store;
    }

    public static List<Spatial> getSpatialsByRole(Spatial rootNode, final String targetRol) {
        final ArrayList<Spatial> result = new ArrayList<Spatial>();
        SceneGraphVisitor visitor = new SceneGraphVisitor(){

            public void visit(Spatial spat) {
                String rol = (String)spat.getUserData("ROLE");
                if (rol != null && rol.equals(targetRol)) {
                    result.add(spat);
                }
            }
        };
        rootNode.breadthFirstTraversal(visitor);
        return result;
    }

    public static Spatial getNearest(Spatial spatial, String targetRol) {
        Spatial result = null;
        float minDist = Float.MAX_VALUE;
        for (Spatial s : SpatialUtils.getSpatialsByRole((Spatial)SpatialUtils.getRootNode(spatial), targetRol)) {
            float distance = s.getWorldTranslation().distance(spatial.getWorldTranslation());
            if (!(distance < minDist)) continue;
            minDist = distance;
            result = s;
        }
        return result;
    }

    public static void printControls(Spatial spatial) {
        System.out.println("Controls of " + spatial.getName());
        for (int i = 0; i < spatial.getNumControls(); ++i) {
            Control c = spatial.getControl(i);
            System.out.print("\t-" + c.getClass().getSimpleName());
            if (c instanceof AbstractControl) {
                System.out.println(" " + ((AbstractControl)c).isEnabled());
                continue;
            }
            if (c instanceof AbstractPhysicsControl) {
                System.out.println(" " + ((AbstractPhysicsControl)c).isEnabled());
                continue;
            }
            System.out.println("");
        }
        System.out.println("");
    }

    public static void printParents(Spatial spatial) {
        String tab = "\t";
        System.out.println(spatial + ":");
        for (Node parent = spatial.getParent(); parent != null; parent = parent.getParent()) {
            System.out.println(tab + parent.getName());
        }
    }

    public static void printChildrens(Spatial spatial) {
        SpatialUtils.printChindrens(spatial, 0);
    }

    private static void printChindrens(Spatial spatial, int depth) {
        for (int i = 0; i < depth; ++i) {
            System.out.print("\t");
        }
        System.out.println("->" + spatial.getName());
        if (spatial instanceof Node) {
            Node parent = (Node)spatial;
            for (Spatial child : parent.getChildren()) {
                SpatialUtils.printChindrens(child, depth + 1);
            }
        }
    }
}

