/*
 * Decompiled with CFR 0.152.
 */
package phat.util;

import com.jme3.app.SimpleApplication;
import com.jme3.app.state.AppState;
import com.jme3.bullet.BulletAppState;
import com.jme3.light.AmbientLight;
import com.jme3.light.Light;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector3f;
import phat.util.SpatialFactory;

public abstract class SimpleScenario
extends SimpleApplication {
    boolean physicsDebugging = false;
    protected BulletAppState bulletAppState;

    public void simpleInitApp() {
        SpatialFactory.init(this.assetManager, this.rootNode);
        this.createPhysicsEngineAndAttachItToScene();
        this.createTerrain();
        this.createLight();
        this.createOtherObjects();
        this.createCameras();
    }

    public abstract void createTerrain();

    public abstract void createOtherObjects();

    protected void createCameras() {
        this.flyCam.setMoveSpeed(10.0f);
        this.flyCam.setDragToRotate(true);
        this.cam.setLocation(new Vector3f(7.0357456f, 11.175021f, 5.927986f));
        this.cam.lookAt(this.rootNode.getWorldBound().getCenter(), Vector3f.UNIT_Y);
    }

    protected void createPhysicsEngineAndAttachItToScene() {
        this.bulletAppState = new BulletAppState();
        this.bulletAppState.setThreadingType(BulletAppState.ThreadingType.PARALLEL);
        this.bulletAppState.setEnabled(true);
        this.stateManager.attach((AppState)this.bulletAppState);
        if (this.physicsDebugging) {
            this.bulletAppState.getPhysicsSpace().enableDebug(this.assetManager);
        }
    }

    protected void createLight() {
        AmbientLight al = new AmbientLight();
        al.setColor(ColorRGBA.White.mult(0.6f));
        this.rootNode.addLight((Light)al);
    }

    public boolean isPhysicsDebugging() {
        return this.physicsDebugging;
    }

    public void setPhysicsDebugging(boolean physicsDebugging) {
        this.physicsDebugging = physicsDebugging;
    }
}

