/*
 * Decompiled with CFR 0.152.
 */
package phat.util;

import com.jme3.asset.AssetManager;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector3f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.debug.Arrow;
import com.jme3.scene.debug.Grid;

public class Debug {
    public static void enableDebugGrid(float size, AssetManager assetManager, Node rootNode) {
        Debug.attachCoordinateAxes(Vector3f.ZERO, size, assetManager, rootNode);
        Debug.attachGrid(Vector3f.ZERO, size * 2.0f, ColorRGBA.Cyan, assetManager, rootNode);
    }

    public static void attachLocalCoordinateAxes(Node node, float size, AssetManager assetManager, Node rootNode) {
        Node n = new Node();
        n.setLocalTranslation(node.getWorldTranslation());
        rootNode.attachChild((Spatial)n);
        Arrow arrow = new Arrow(node.getWorldRotation().mult(Vector3f.UNIT_X).normalize().mult(size));
        arrow.setLineWidth(4.0f);
        Debug.putShape((Mesh)arrow, ColorRGBA.Red, assetManager, n);
        arrow = new Arrow(node.getWorldRotation().mult(Vector3f.UNIT_Y).normalize().mult(size));
        arrow.setLineWidth(4.0f);
        Debug.putShape((Mesh)arrow, ColorRGBA.Green, assetManager, n);
        arrow = new Arrow(node.getWorldRotation().mult(Vector3f.UNIT_Z).normalize().mult(size));
        arrow.setLineWidth(4.0f);
        Debug.putShape((Mesh)arrow, ColorRGBA.Blue, assetManager, n);
    }

    public static void attachCoordinateAxes(Vector3f pos, float size, AssetManager assetManager, Node rootNode) {
        Arrow arrow = new Arrow(Vector3f.UNIT_X.mult(size));
        arrow.setLineWidth(4.0f);
        Debug.putShape((Mesh)arrow, ColorRGBA.Red, assetManager, rootNode).setLocalTranslation(pos);
        arrow = new Arrow(Vector3f.UNIT_Y.mult(size));
        arrow.setLineWidth(4.0f);
        Debug.putShape((Mesh)arrow, ColorRGBA.Blue, assetManager, rootNode).setLocalTranslation(pos);
        arrow = new Arrow(Vector3f.UNIT_Z.mult(size));
        arrow.setLineWidth(4.0f);
        Debug.putShape((Mesh)arrow, ColorRGBA.Green, assetManager, rootNode).setLocalTranslation(pos);
    }

    private static Geometry putShape(Mesh shape, ColorRGBA color, AssetManager assetManager, Node rootNode) {
        Geometry g = new Geometry("coordinate axis", shape);
        Material mat = new Material(assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
        mat.getAdditionalRenderState().setWireframe(true);
        mat.setColor("Color", color);
        g.setMaterial(mat);
        rootNode.attachChild((Spatial)g);
        return g;
    }

    private static void attachGrid(Vector3f pos, float size, ColorRGBA color, AssetManager assetManager, Node rootNode) {
        Geometry g = new Geometry("wireframe grid", (Mesh)new Grid((int)size, (int)size, 1.0f));
        Material mat = new Material(assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
        mat.getAdditionalRenderState().setWireframe(true);
        mat.setColor("Color", color);
        g.setMaterial(mat);
        g.center().move(pos);
        rootNode.attachChild((Spatial)g);
    }
}

