/*
 * Decompiled with CFR 0.152.
 */
package phat.sensors.camera;

import com.jme3.post.SceneProcessor;
import com.jme3.renderer.Camera;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.ViewPort;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.texture.FrameBuffer;
import com.jme3.util.BufferUtils;
import java.awt.image.BufferedImage;
import java.nio.ByteBuffer;
import phat.sensors.Sensor;
import phat.sensors.camera.CameraSensorData;
import phat.util.ConvertBgraToAbgr;

public class CameraSensor
extends Sensor
implements SceneProcessor {
    boolean initialized = false;
    RenderManager renderManager;
    ViewPort viewPort;
    ByteBuffer outBuf;
    int width;
    int height;
    BufferedImage rawFrame;
    float cfps = 0.0f;

    public CameraSensor(String id) {
        super(id);
    }

    public void initialize(RenderManager rm, ViewPort vp) {
        this.renderManager = rm;
        this.viewPort = vp;
        this.reshape(vp, vp.getCamera().getWidth(), vp.getCamera().getHeight());
        this.initialized = true;
    }

    public void reshape(ViewPort vp, int w, int h) {
        this.outBuf = BufferUtils.createByteBuffer((int)(w * h * 4));
        this.rawFrame = new BufferedImage(w, h, 6);
        this.width = w;
        this.height = h;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (enabled) {
            if (this.viewPort != null) {
                this.viewPort.addProcessor((SceneProcessor)this);
            }
        } else if (this.viewPort != null) {
            this.viewPort.removeProcessor((SceneProcessor)this);
        }
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void preFrame(float fps) {
        this.cfps = fps;
    }

    public void postQueue(RenderQueue rq) {
    }

    private void process1(FrameBuffer fb) {
        Camera curCamera = this.viewPort.getCamera();
        int viewX = (int)(curCamera.getViewPortLeft() * (float)curCamera.getWidth());
        int viewY = (int)(curCamera.getViewPortBottom() * (float)curCamera.getHeight());
        int viewWidth = (int)((curCamera.getViewPortRight() - curCamera.getViewPortLeft()) * (float)curCamera.getWidth());
        int viewHeight = (int)((curCamera.getViewPortTop() - curCamera.getViewPortBottom()) * (float)curCamera.getHeight());
        this.renderManager.getRenderer().setViewPort(0, 0, this.width, this.height);
        this.renderManager.getRenderer().readFrameBuffer(fb, this.outBuf);
        this.renderManager.getRenderer().setViewPort(viewX, viewY, viewWidth, viewHeight);
    }

    private void process2(FrameBuffer fb) {
        Camera cam = this.renderManager.getCurrentCamera();
        Camera curCamera = this.viewPort.getCamera();
        float viewX = curCamera.getViewPortLeft();
        float viewY = curCamera.getViewPortBottom();
        float viewWidth = curCamera.getViewPortRight();
        float viewHeight = curCamera.getViewPortTop();
        float xFactor = (float)cam.getWidth() / (float)curCamera.getWidth();
        float yFactor = (float)cam.getHeight() / (float)curCamera.getHeight();
        this.viewPort.getCamera().setViewPort(0.0f, 1.0f * xFactor, 0.0f, 1.0f * yFactor);
        this.renderManager.getRenderer().readFrameBuffer(fb, this.outBuf);
        this.viewPort.getCamera().setViewPort(viewX, viewWidth, viewY, viewHeight);
    }

    private void process3(FrameBuffer fb) {
        Camera curCamera = this.viewPort.getCamera();
        int viewX = (int)(curCamera.getViewPortLeft() * (float)curCamera.getWidth());
        int viewY = (int)(curCamera.getViewPortBottom() * (float)curCamera.getHeight());
        int viewWidth = (int)((curCamera.getViewPortRight() - curCamera.getViewPortLeft()) * (float)curCamera.getWidth());
        int viewHeight = (int)((curCamera.getViewPortTop() - curCamera.getViewPortBottom()) * (float)curCamera.getHeight());
        this.renderManager.getRenderer().setViewPort(320, 640, 0, 240);
        this.renderManager.getRenderer().readFrameBuffer(fb, this.outBuf);
        this.renderManager.getRenderer().setViewPort(0, 0, this.width, this.height);
    }

    public void easy(FrameBuffer fb) {
        this.renderManager.getRenderer().readFrameBuffer(fb, this.outBuf);
        ConvertBgraToAbgr.convert(this.outBuf, this.rawFrame);
    }

    public void postFrame(FrameBuffer fb) {
        if (this.enabled) {
            this.easy(fb);
            CameraSensorData csd = new CameraSensorData(this.cfps, this.rawFrame, this.width, this.height, 0);
            this.notifyListeners(csd);
        }
    }

    public void cleanup() {
    }

    protected void controlUpdate(float fps) {
    }

    protected void controlRender(RenderManager rm, ViewPort vp) {
    }
}

