/*
 * Decompiled with CFR 0.152.
 */
package phat.sensors.accelerometer;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Paint;
import java.awt.Window;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;
import phat.sensors.Sensor;
import phat.sensors.SensorData;
import phat.sensors.SensorListener;
import phat.sensors.accelerometer.AccelerationData;

public class XYAccelerationsChart
extends ApplicationFrame
implements SensorListener {
    XYSeries xAcceleration = new XYSeries((Comparable)((Object)"x acc."));
    XYSeries yAcceleration = new XYSeries((Comparable)((Object)"y acc."));
    XYSeries zAcceleration = new XYSeries((Comparable)((Object)"z acc."));
    XYSeriesCollection dataset = new XYSeriesCollection();
    JFreeChart chart;
    XYPlot plot;
    ChartPanel chartPanel;
    float acumulativeTime = 0.0f;

    public XYAccelerationsChart(String windowstitle, String chartTitle, String domainAxisLabel, String rangeAxisLabel) {
        super(windowstitle);
        this.dataset.addSeries(this.xAcceleration);
        this.dataset.addSeries(this.yAcceleration);
        this.dataset.addSeries(this.zAcceleration);
        this.chart = ChartFactory.createXYLineChart((String)chartTitle, (String)domainAxisLabel, (String)rangeAxisLabel, (XYDataset)this.dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        this.plot = this.chart.getXYPlot();
        this.chart.setBackgroundPaint((Paint)Color.white);
        this.plot.setOutlinePaint((Paint)Color.black);
        this.chartPanel = new ChartPanel(this.chart);
        this.chartPanel.setPreferredSize(new Dimension(500, 270));
        this.setContentPane((Container)this.chartPanel);
    }

    public void showWindow() {
        this.pack();
        RefineryUtilities.centerFrameOnScreen((Window)((Object)this));
        this.setVisible(true);
    }

    @Override
    public void update(Sensor source, SensorData sd) {
        if (sd instanceof AccelerationData) {
            AccelerationData ad = (AccelerationData)sd;
            this.acumulativeTime += ad.getInterval();
            this.xAcceleration.add((double)this.acumulativeTime, (double)ad.getX());
            this.yAcceleration.add((double)this.acumulativeTime, (double)ad.getY());
            this.zAcceleration.add((double)this.acumulativeTime, (double)ad.getZ());
            this.chartPanel.updateUI();
        }
    }

    public void stop() {
    }

    @Override
    public void cleanUp() {
        this.setVisible(false);
        this.xAcceleration = null;
        this.yAcceleration = null;
        this.zAcceleration = null;
        this.dataset = null;
        this.chart = null;
        this.plot = null;
        this.chartPanel = null;
    }
}

