/*
 * Decompiled with CFR 0.152.
 */
package phat.sensors;

import com.jme3.scene.Spatial;
import com.jme3.scene.control.AbstractControl;
import com.jme3.scene.control.Control;
import java.util.ArrayList;
import java.util.List;
import phat.sensors.SensorData;
import phat.sensors.SensorListener;
import phat.sensors.SensorNotificationLauncher;

public abstract class Sensor
extends AbstractControl {
    protected String id;
    protected List<SensorListener> listeners;
    SensorNotificationLauncher launcher;

    public Sensor(String id) {
        this.id = id;
        this.listeners = new ArrayList<SensorListener>();
        this.launcher = new SensorNotificationLauncher(this.listeners, this);
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public void add(SensorListener sensorListener) {
        if (!this.listeners.contains(sensorListener)) {
            this.listeners.add(sensorListener);
            if (!this.isEnabled()) {
                this.setEnabled(true);
            }
        }
    }

    public boolean hasListener(SensorListener sl) {
        return this.listeners.contains(sl);
    }

    public void remove(SensorListener sensorListener) {
        this.listeners.remove(sensorListener);
        if (this.listeners.isEmpty() && this.isEnabled()) {
            this.setEnabled(false);
        }
    }

    protected void notifyListeners(SensorData sourceData) {
        this.launcher.notify(sourceData);
    }

    protected Control cloneControl(Control control, Spatial spatial) {
        if (control instanceof Sensor) {
            Sensor sensor = (Sensor)control;
            sensor.setId(this.id);
            sensor.listeners.addAll(this.listeners);
        }
        return control;
    }

    public void cleanUp() {
        for (SensorListener sl : this.listeners) {
            sl.cleanUp();
        }
        this.listeners.clear();
    }
}

