/*
 * Decompiled with CFR 0.152.
 */
package phat.scene.control;

import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.ViewPort;
import com.jme3.scene.Spatial;
import com.jme3.scene.control.BillboardControl;
import phat.util.SpatialUtils;

public class PHATBillboardControl
extends BillboardControl {
    Vector3f offset = new Vector3f(0.0f, 0.5f, 0.0f);
    Vector3f center = new Vector3f();
    Vector3f loc = new Vector3f();
    Spatial head;
    Quaternion rotation = new Quaternion();
    boolean updatedLoc = false;
    float[] angles = new float[3];

    public void setSpatial(Spatial spatial) {
        super.setSpatial(spatial);
    }

    public void update(float fps) {
        super.update(fps);
        this.updateLocation(this.spatial);
    }

    protected void controlRender(RenderManager rm, ViewPort vp) {
        super.controlRender(rm, vp);
    }

    private void updateLocation(Spatial spatial) {
        if (this.head == null) {
            this.head = spatial.getParent().getParent().getChild("male/head/middle_aged");
        }
        this.loc.set(spatial.getParent().getWorldTranslation());
        this.center.set(SpatialUtils.getCenterBoinding(this.head));
        this.center.subtractLocal(this.loc);
        this.center.addLocal(this.offset);
        spatial.setLocalTranslation(this.center);
        this.rotation.set(spatial.getParent().getParent().getLocalRotation());
        this.rotation.toAngles(this.angles);
        this.angles[0] = this.angles[0] * -1.0f;
        this.angles[1] = this.angles[1] * -1.0f;
        this.angles[2] = this.angles[2] * -1.0f;
        this.rotation.fromAngles(this.angles);
        spatial.getParent().setLocalRotation(this.rotation);
    }

    public Vector3f getOffset() {
        return this.offset;
    }

    public void setOffset(Vector3f offset) {
        this.offset = offset;
    }
}

